/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Vector;
import org.jgroups.Event;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class QUEUE
extends Protocol {
    Vector up_vec = new Vector();
    Vector dn_vec = new Vector();
    boolean queueing_up = false;
    boolean queueing_dn = false;
    Observer observer = null;

    public void setObserver(Observer observer) {
        this.observer = observer;
    }

    public Vector getUpVector() {
        return this.up_vec;
    }

    public Vector getDownVector() {
        return this.dn_vec;
    }

    public boolean getQueueingUp() {
        return this.queueing_up;
    }

    public boolean getQueueingDown() {
        return this.queueing_dn;
    }

    public String getName() {
        return "QUEUE";
    }

    public Vector providedUpServices() {
        Vector<Integer> ret = new Vector<Integer>();
        ret.addElement(new Integer(22));
        ret.addElement(new Integer(23));
        return ret;
    }

    public Vector providedDownServices() {
        Vector<Integer> ret = new Vector<Integer>();
        ret.addElement(new Integer(22));
        ret.addElement(new Integer(23));
        return ret;
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 22: {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"received START_QUEUEING");
                }
                this.queueing_up = true;
                return;
            }
            case 23: {
                int i;
                Vector event_list = (Vector)evt.getArg();
                if (event_list != null) {
                    for (i = 0; i < event_list.size(); ++i) {
                        this.passUp((Event)event_list.elementAt(i));
                    }
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"replaying up events");
                }
                for (i = 0; i < this.up_vec.size(); ++i) {
                    Event e = (Event)this.up_vec.elementAt(i);
                    this.passUp(e);
                }
                this.up_vec.removeAllElements();
                this.queueing_up = false;
                return;
            }
        }
        if (this.queueing_up) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("queued up event " + evt));
            }
            if (this.observer != null && !this.observer.addingToUpVector(evt, this.up_vec.size())) {
                return;
            }
            this.up_vec.addElement(evt);
        } else {
            this.passUp(evt);
        }
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 22: {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"received START_QUEUEING");
                }
                this.queueing_dn = true;
                return;
            }
            case 23: {
                int i;
                Vector event_list;
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"received STOP_QUEUEING");
                }
                if ((event_list = (Vector)evt.getArg()) != null) {
                    for (i = 0; i < event_list.size(); ++i) {
                        this.passDown((Event)event_list.elementAt(i));
                    }
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("replaying down events (" + this.dn_vec.size() + ')'));
                }
                for (i = 0; i < this.dn_vec.size(); ++i) {
                    this.passDown((Event)this.dn_vec.elementAt(i));
                }
                this.dn_vec.removeAllElements();
                this.queueing_dn = false;
                return;
            }
        }
        if (this.queueing_dn) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("queued down event: " + Util.printEvent(evt)));
            }
            if (this.observer != null && !this.observer.addingToDownVector(evt, this.dn_vec.size())) {
                return;
            }
            this.dn_vec.addElement(evt);
        } else {
            this.passDown(evt);
        }
    }

    public static interface Observer {
        public boolean addingToUpVector(Event var1, int var2);

        public boolean addingToDownVector(Event var1, int var2);
    }
}

