/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.stack.Retransmitter;
import org.jgroups.util.List;
import org.jgroups.util.RWLock;
import org.jgroups.util.TimeScheduler;

public class NakReceiverWindow {
    private RWLock lock = new RWLock();
    private long head = 0L;
    private long tail = 0L;
    private long lowest_seen = 0L;
    private long highest_seen = 0L;
    private TreeMap received_msgs = new TreeMap();
    private TreeMap delivered_msgs = new TreeMap();
    private boolean discard_delivered_msgs = false;
    private Retransmitter retransmitter = null;
    protected static Log log = LogFactory.getLog((Class)(class$org$jgroups$stack$NakReceiverWindow == null ? (class$org$jgroups$stack$NakReceiverWindow = NakReceiverWindow.class$("org.jgroups.stack.NakReceiverWindow")) : class$org$jgroups$stack$NakReceiverWindow));
    static /* synthetic */ Class class$org$jgroups$stack$NakReceiverWindow;

    public NakReceiverWindow(Address sender, Retransmitter.RetransmitCommand cmd, long start_seqno, TimeScheduler sched) {
        this.tail = this.head = start_seqno;
        if (cmd != null) {
            this.retransmitter = sched == null ? new Retransmitter(sender, cmd) : new Retransmitter(sender, cmd, sched);
        }
    }

    public NakReceiverWindow(Address sender, Retransmitter.RetransmitCommand cmd, long start_seqno) {
        this(sender, cmd, start_seqno, null);
    }

    public NakReceiverWindow(Address sender, long start_seqno) {
        this(sender, null, start_seqno);
    }

    public void setRetransmitTimeouts(long[] timeouts) {
        if (this.retransmitter != null) {
            this.retransmitter.setRetransmitTimeouts(timeouts);
        }
    }

    public void setDiscardDeliveredMessages(boolean flag) {
        this.discard_delivered_msgs = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long seqno, Message msg) {
        this.lock.writeLock();
        try {
            long old_tail = this.tail;
            if (seqno < this.head) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("seqno " + seqno + " is smaller than " + this.head + "); discarding message"));
                }
                return;
            }
            if (seqno == this.tail) {
                this.received_msgs.put(new Long(seqno), msg);
                ++this.tail;
            } else if (seqno > this.tail) {
                for (long i = this.tail; i < seqno; ++i) {
                    this.received_msgs.put(new Long(i), null);
                    ++this.tail;
                }
                this.received_msgs.put(new Long(seqno), msg);
                this.tail = seqno + 1L;
                if (this.retransmitter != null) {
                    this.retransmitter.add(old_tail, seqno - 1L);
                }
            } else if (seqno < this.tail) {
                Object val;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("added missing msg " + msg.getSrc() + '#' + seqno));
                }
                if ((val = this.received_msgs.get(new Long(seqno))) == null) {
                    this.received_msgs.put(new Long(seqno), msg);
                    if (this.retransmitter != null) {
                        this.retransmitter.remove(seqno);
                    }
                }
            }
            this.updateLowestSeen();
            this.updateHighestSeen();
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message remove() {
        Message retval = null;
        this.lock.writeLock();
        try {
            Object key;
            if (this.received_msgs.size() > 0 && (retval = (Message)this.received_msgs.get(key = this.received_msgs.firstKey())) != null) {
                this.received_msgs.remove(key);
                if (!this.discard_delivered_msgs) {
                    this.delivered_msgs.put(key, retval);
                }
                ++this.head;
            }
            Message message = retval;
            return message;
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stable(long seqno) {
        this.lock.writeLock();
        try {
            SortedMap m = this.delivered_msgs.headMap(new Long(seqno + 1L));
            if (m.size() > 0) {
                this.lowest_seen = Math.max(this.lowest_seen, m.lastKey());
            }
            m.clear();
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.lock.writeLock();
        try {
            if (this.retransmitter != null) {
                this.retransmitter.reset();
            }
            this._reset();
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.lock.writeLock();
        try {
            if (this.retransmitter != null) {
                this.retransmitter.stop();
            }
            this._reset();
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestDelivered() {
        this.lock.readLock();
        try {
            long l = Math.max(this.head - 1L, -1L);
            return l;
        }
        finally {
            this.lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLowestSeen() {
        this.lock.readLock();
        try {
            long l = this.lowest_seen;
            return l;
        }
        finally {
            this.lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestSeen() {
        this.lock.readLock();
        try {
            long l = this.highest_seen;
            return l;
        }
        finally {
            this.lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMissingMessages(long low, long high) {
        List retval = new List();
        if (low > high) {
            if (log.isErrorEnabled()) {
                log.error((Object)("invalid range: low (" + low + ") is higher than high (" + high + ')'));
            }
            return null;
        }
        this.lock.readLock();
        try {
            SortedMap m = this.received_msgs.subMap(new Long(low), new Long(high + 1L));
            Iterator<Long> it = m.keySet().iterator();
            while (it.hasNext()) {
                retval.add(it.next());
            }
            List list = retval;
            return list;
        }
        finally {
            this.lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestReceived() {
        this.lock.readLock();
        try {
            long l = Math.max(this.tail - 1L, -1L);
            return l;
        }
        finally {
            this.lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessagesHigherThan(long seqno) {
        List retval = new List();
        this.lock.readLock();
        try {
            SortedMap m = this.received_msgs.tailMap(new Long(seqno + 1L));
            Iterator it = m.values().iterator();
            while (it.hasNext()) {
                retval.add(it.next());
            }
            m = this.delivered_msgs.tailMap(new Long(seqno + 1L));
            it = m.values().iterator();
            while (it.hasNext()) {
                retval.add(((Message)it.next()).copy());
            }
            List list = retval;
            return list;
        }
        finally {
            this.lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessagesInRange(long lower, long upper) {
        List retval = new List();
        this.lock.readLock();
        try {
            SortedMap m = this.received_msgs.subMap(new Long(lower + 1L), new Long(upper + 1L));
            Iterator it = m.values().iterator();
            while (it.hasNext()) {
                retval.add(it.next());
            }
            m = this.delivered_msgs.subMap(new Long(lower + 1L), new Long(upper + 1L));
            it = m.values().iterator();
            while (it.hasNext()) {
                retval.add(((Message)it.next()).copy());
            }
            List list = retval;
            return list;
        }
        finally {
            this.lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessagesInList(List missing_msgs) {
        List ret = new List();
        if (missing_msgs == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"argument list is null");
            }
            return ret;
        }
        this.lock.readLock();
        try {
            Enumeration en = missing_msgs.elements();
            while (en.hasMoreElements()) {
                Long seqno = (Long)en.nextElement();
                Message msg = (Message)this.delivered_msgs.get(seqno);
                if (msg != null) {
                    ret.add(msg.copy());
                }
                if ((msg = (Message)this.received_msgs.get(seqno)) == null) continue;
                ret.add(msg.copy());
            }
            List list = ret;
            return list;
        }
        finally {
            this.lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock.readLock();
        try {
            int n = this.received_msgs.size();
            return n;
        }
        finally {
            this.lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.lock.readLock();
        try {
            sb.append("received_msgs: " + this.printReceivedMessages());
            sb.append(", delivered_msgs: " + this.printDeliveredMessages());
        }
        finally {
            this.lock.readUnlock();
        }
        return sb.toString();
    }

    String printDeliveredMessages() {
        StringBuffer sb = new StringBuffer();
        Long min = null;
        Long max = null;
        if (this.delivered_msgs.size() > 0) {
            try {
                min = (Long)this.delivered_msgs.firstKey();
            }
            catch (NoSuchElementException ex) {
                // empty catch block
            }
            try {
                max = (Long)this.delivered_msgs.lastKey();
            }
            catch (NoSuchElementException ex) {
                // empty catch block
            }
        }
        sb.append('[').append(min).append(" - ").append(max).append(']');
        return sb.toString();
    }

    String printReceivedMessages() {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        if (this.received_msgs.size() > 0) {
            Long first = null;
            Long last = null;
            try {
                first = (Long)this.received_msgs.firstKey();
            }
            catch (NoSuchElementException ex) {
                // empty catch block
            }
            try {
                last = (Long)this.received_msgs.lastKey();
            }
            catch (NoSuchElementException ex) {
                // empty catch block
            }
            sb.append(first).append(" - ").append(last);
            int non_received = 0;
            Iterator it = this.received_msgs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (entry.getValue() != null) continue;
                ++non_received;
            }
            sb.append(" (size=").append(this.received_msgs.size()).append(", missing=").append(non_received).append(')');
        }
        sb.append(']');
        return sb.toString();
    }

    private void updateLowestSeen() {
        Long lowest_seqno = null;
        if (this.delivered_msgs.size() > 0) {
            try {
                lowest_seqno = (Long)this.delivered_msgs.firstKey();
                if (lowest_seqno != null) {
                    this.lowest_seen = lowest_seqno;
                }
            }
            catch (NoSuchElementException ex) {}
        } else if (this.received_msgs.size() > 0) {
            try {
                lowest_seqno = (Long)this.received_msgs.firstKey();
                if (this.received_msgs.get(lowest_seqno) != null) {
                    this.lowest_seen = lowest_seqno;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    private void updateHighestSeen() {
        long ret = 0L;
        Map.Entry entry = null;
        Long highest_seqno = null;
        if (this.delivered_msgs.size() > 0) {
            try {
                highest_seqno = (Long)this.delivered_msgs.lastKey();
                ret = highest_seqno;
            }
            catch (NoSuchElementException ex) {}
        } else {
            ret = Math.max(this.head - 1L, 0L);
        }
        Iterator it = this.received_msgs.entrySet().iterator();
        while (it.hasNext() && (entry = it.next()).getValue() != null) {
            ret = (Long)entry.getKey();
        }
        this.highest_seen = Math.max(ret, 0L);
    }

    private void _reset() {
        this.received_msgs.clear();
        this.delivered_msgs.clear();
        this.head = 0L;
        this.tail = 0L;
        this.lowest_seen = 0L;
        this.highest_seen = 0L;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

