/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.debug.ProtocolTester;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class FragTest
extends TestCase {
    public final long NUM_MSGS = 10L;
    public final int MSG_SIZE = 100000;
    public final int FRAG_SIZE = 24000;
    static /* synthetic */ Class class$org$jgroups$tests$FragTest;

    public FragTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    private Message createBigMessage(int size) {
        byte[] buf = new byte[size];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = 120;
        }
        return new Message(null, null, buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test0() throws Exception {
        Object mutex = new Object();
        FragReceiver frag_receiver = new FragReceiver(this, mutex);
        ProtocolTester t = new ProtocolTester("FRAG(frag_size=24000)", frag_receiver);
        IpAddress local_addr = new IpAddress(5555);
        System.out.println("\nProtocol for protocol tester: " + t.getProtocolSpec() + '\n');
        Object object = mutex;
        synchronized (object) {
            int i = 0;
            while ((long)i < 10L) {
                Message big_msg = this.createBigMessage(100000);
                big_msg.setSrc(local_addr);
                System.out.println("sending msg #" + i + " [" + big_msg.getLength() + " bytes]");
                frag_receiver.down(new Event(1, big_msg));
                Util.sleep(10L);
                ++i;
            }
        }
        t.stop();
    }

    public static Test suite() {
        TestSuite s = new TestSuite(class$org$jgroups$tests$FragTest == null ? (class$org$jgroups$tests$FragTest = FragTest.class$("org.jgroups.tests.FragTest")) : class$org$jgroups$tests$FragTest);
        return s;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)FragTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FragReceiver
    extends Protocol {
        long num_msgs = 0L;
        FragTest t = null;
        Object mut = null;

        FragReceiver(FragTest t, Object mut) {
            this.t = t;
            this.mut = mut;
        }

        public String getName() {
            return "FragReceiver";
        }

        public void up(Event evt) {
            Message msg = null;
            if (evt == null || evt.getType() != 1) {
                return;
            }
            msg = (Message)evt.getArg();
            Address sender = msg.getSrc();
            if (sender == null) {
                System.err.println("FragTest.FragReceiver.up(): sender is null; discarding msg");
                return;
            }
            System.out.println("Received msg from " + sender + " [" + msg.getLength() + " bytes]");
        }
    }
}

