/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf;

import java.io.Serializable;
import java.text.NumberFormat;

public class MemberInfo
implements Serializable {
    public long start = 0L;
    public long stop = 0L;
    public long num_msgs_expected = 0L;
    public long num_msgs_received = 0L;
    boolean done = false;
    long total_bytes_received = 0L;
    static NumberFormat f = NumberFormat.getNumberInstance();

    public MemberInfo(long num_msgs_expected) {
        this.num_msgs_expected = num_msgs_expected;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        double throughput_kb = 0.0;
        double throughput_mb = 0.0;
        double kb_received = 0.0;
        double mb_received = 0.0;
        long total_time = this.stop - this.start;
        double loss_rate = 0.0;
        long missing_msgs = this.num_msgs_expected - this.num_msgs_received;
        kb_received = (double)this.total_bytes_received / 1000.0;
        if (kb_received >= 1000.0) {
            mb_received = kb_received / 1000.0;
        }
        double msgs_sec = (double)this.num_msgs_received / ((double)total_time / 1000.0);
        throughput_kb = kb_received / ((double)total_time / 1000.0);
        if (throughput_kb >= 1000.0) {
            throughput_mb = throughput_kb / 1000.0;
        }
        loss_rate = missing_msgs >= this.num_msgs_expected ? 100.0 : 100.0 / (double)this.num_msgs_expected * (double)missing_msgs;
        sb.append("num_msgs_expected=").append(this.num_msgs_expected).append(", num_msgs_received=");
        sb.append(this.num_msgs_received);
        sb.append(" (loss rate=").append(f.format(loss_rate)).append("%)");
        if (mb_received > 0.0) {
            sb.append(", received=").append(f.format(mb_received)).append("MB");
        } else {
            sb.append(", received=").append(f.format(kb_received)).append("KB");
        }
        sb.append(", time=").append(f.format(total_time)).append("ms");
        sb.append(", msgs/sec=").append(f.format(msgs_sec));
        if (throughput_mb > 0.0) {
            sb.append(", throughput=").append(f.format(throughput_mb)).append("MB/sec");
        } else {
            sb.append(", throughput=").append(f.format(throughput_kb)).append("KB/sec");
        }
        return sb.toString();
    }

    static {
        f.setGroupingUsed(false);
        f.setMaximumFractionDigits(2);
    }
}

