/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.TimeoutException;
import org.jgroups.util.QueueClosedException;

public class Queue {
    Element head = null;
    Element tail = null;
    boolean closed = false;
    int size = 0;
    Object mutex = new Object();
    int num_markers = 0;
    private static final Object endMarker = new Object();
    protected static Log log = LogFactory.getLog((Class)(class$org$jgroups$util$Queue == null ? (class$org$jgroups$util$Queue = Queue.class$("org.jgroups.util.Queue")) : class$org$jgroups$util$Queue));
    static /* synthetic */ Class class$org$jgroups$util$Queue;

    public Object getFirst() {
        return this.head != null ? this.head.obj : null;
    }

    public Object getLast() {
        return this.tail != null ? this.tail.obj : null;
    }

    public boolean closed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object obj) throws QueueClosedException {
        if (obj == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"argument must not be null");
            }
            return;
        }
        if (this.closed) {
            throw new QueueClosedException();
        }
        if (this.num_markers > 0) {
            throw new QueueClosedException("Queue.add(): queue has been closed. You can not add more elements. Waiting for removal of remaining elements.");
        }
        Object object = this.mutex;
        synchronized (object) {
            Element el = new Element(obj);
            if (this.head == null) {
                this.tail = this.head = el;
                this.size = 1;
            } else {
                this.tail.next = el;
                this.tail = el;
                ++this.size;
            }
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAtHead(Object obj) throws QueueClosedException {
        if (obj == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"argument must not be null");
            }
            return;
        }
        if (this.closed) {
            throw new QueueClosedException();
        }
        if (this.num_markers > 0) {
            throw new QueueClosedException("Queue.addAtHead(): queue has been closed. You can not add more elements. Waiting for removal of remaining elements.");
        }
        Object object = this.mutex;
        synchronized (object) {
            Element el = new Element(obj);
            if (this.head == null) {
                this.tail = this.head = el;
                this.size = 1;
            } else {
                el.next = this.head;
                this.head = el;
                ++this.size;
            }
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove() throws QueueClosedException {
        Object retval = null;
        Object object = this.mutex;
        synchronized (object) {
            while (this.size == 0) {
                if (this.closed) {
                    throw new QueueClosedException();
                }
                try {
                    this.mutex.wait();
                }
                catch (IllegalMonitorStateException ex) {
                    throw ex;
                }
                catch (InterruptedException interruptedException) {
                }
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
            retval = this.removeInternal();
            if (retval == null && log.isErrorEnabled()) {
                log.error((Object)"element was null, should never be the case");
            }
        }
        if (retval == endMarker) {
            this.close(false);
            throw new QueueClosedException();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(long timeout) throws QueueClosedException, TimeoutException {
        Object retval = null;
        Object object = this.mutex;
        synchronized (object) {
            if (this.size == 0) {
                if (this.closed) {
                    throw new QueueClosedException();
                }
                try {
                    this.mutex.wait(timeout);
                }
                catch (IllegalMonitorStateException ex) {
                    throw ex;
                }
                catch (IllegalArgumentException ex2) {
                    throw ex2;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
            retval = this.removeInternal();
            if (retval == null) {
                throw new TimeoutException();
            }
            if (retval == endMarker) {
                this.close(false);
                throw new QueueClosedException();
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(Object obj) throws QueueClosedException {
        if (obj == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"argument must not be null");
            }
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            Element el = this.head;
            if (el == null) {
                return;
            }
            if (el.obj.equals(obj)) {
                this.head = el.next;
                el.next = null;
                if (this.size == 1) {
                    this.tail = this.head;
                }
                this.decrementSize();
                return;
            }
            while (el.next != null) {
                if (el.next.obj.equals(obj)) {
                    Element tmp_el = el.next;
                    if (tmp_el == this.tail) {
                        this.tail = el;
                    }
                    el.next = el.next.next;
                    tmp_el.next = null;
                    this.decrementSize();
                    break;
                }
                el = el.next;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() throws QueueClosedException {
        Object retval = null;
        Object object = this.mutex;
        synchronized (object) {
            while (this.size == 0) {
                if (this.closed) {
                    throw new QueueClosedException();
                }
                try {
                    this.mutex.wait();
                }
                catch (IllegalMonitorStateException ex) {
                    throw ex;
                }
                catch (InterruptedException interruptedException) {
                }
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
            Object object2 = retval = this.head != null ? this.head.obj : null;
            if (retval == null && log.isErrorEnabled()) {
                log.error((Object)("retval is null: head=" + this.head + ", tail=" + this.tail + ", size()=" + this.size() + ", num_markers=" + this.num_markers + ", closed()=" + this.closed()));
            }
        }
        if (retval == endMarker) {
            this.close(false);
            throw new QueueClosedException();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek(long timeout) throws QueueClosedException, TimeoutException {
        Object retval = null;
        Object object = this.mutex;
        synchronized (object) {
            if (this.size == 0) {
                if (this.closed) {
                    throw new QueueClosedException();
                }
                try {
                    this.mutex.wait(timeout);
                }
                catch (IllegalMonitorStateException ex) {
                    throw ex;
                }
                catch (IllegalArgumentException ex2) {
                    throw ex2;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
            Object object2 = retval = this.head != null ? this.head.obj : null;
            if (retval == null) {
                throw new TimeoutException();
            }
            if (retval == endMarker) {
                this.close(false);
                throw new QueueClosedException();
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean flush_entries) {
        if (flush_entries) {
            try {
                this.add(endMarker);
                ++this.num_markers;
            }
            catch (QueueClosedException queueClosedException) {
                // empty catch block
            }
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.closed = true;
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.num_markers = 0;
        if (!this.closed) {
            this.close(false);
        }
        Object object = this.mutex;
        synchronized (object) {
            this.size = 0;
            this.head = null;
            this.tail = null;
            this.closed = false;
            this.mutex.notifyAll();
        }
    }

    public int size() {
        return this.size - this.num_markers;
    }

    public String toString() {
        return "Queue (" + this.size() + ") messages";
    }

    public String debug() {
        return this.toString() + ", head=" + this.head + ", tail=" + this.tail + ", closed()=" + this.closed() + ", contents=" + this.getContents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getContents() {
        Vector<Object> retval = new Vector<Object>();
        Object object = this.mutex;
        synchronized (object) {
            Element el = this.head;
            while (el != null) {
                retval.addElement(el.obj);
                el = el.next;
            }
        }
        return retval;
    }

    private Object removeInternal() {
        if (this.head == null) {
            return null;
        }
        Element retval = this.head;
        this.head = this.head.next;
        if (this.head == null) {
            this.tail = null;
        }
        this.decrementSize();
        if (this.head != null && this.head.obj == endMarker) {
            this.closed = true;
        }
        retval.next = null;
        return retval.obj;
    }

    void decrementSize() {
        --this.size;
        if (this.size < 0) {
            this.size = 0;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Element {
        Object obj = null;
        Element next = null;

        Element(Object o) {
            this.obj = o;
        }

        public String toString() {
            return this.obj != null ? this.obj.toString() : "null";
        }
    }
}

