/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.findbugs.slf4j;

import com.google.common.base.Objects;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import javax.annotation.Nullable;
import jp.skypencil.findbugs.slf4j.parameter.AbstractDetectorForParameterArray;
import jp.skypencil.findbugs.slf4j.parameter.ArrayData;
import jp.skypencil.findbugs.slf4j.parameter.ArrayDataHandler;

@OpcodeStack.CustomUserValue
public final class ManualMessageDetector
extends AbstractDetectorForParameterArray {
    @OpcodeStack.Item.SpecialKind
    private final int isMessage = OpcodeStack.Item.defineNewSpecialKind((String)"message generated by throwable object");

    public ManualMessageDetector(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    protected ArrayDataHandler.Strategy createArrayCheckStrategy() {
        return new ArrayDataHandler.Strategy(){

            @Override
            public void store(OpcodeStack.Item storedItem, ArrayData arrayData, int index) {
                if (arrayData == null) {
                    return;
                }
                if (storedItem.getSpecialKind() == ManualMessageDetector.this.isMessage) {
                    arrayData.mark(true);
                }
                if (index == arrayData.getSize() - 1 && !ManualMessageDetector.this.getThrowableHandler().checkThrowable(storedItem)) {
                    arrayData.mark(false);
                }
            }
        };
    }

    @Override
    public void afterOpcode(int seen) {
        boolean isInvokingGetMessage = this.isInvokingGetMessage(seen);
        super.afterOpcode(seen);
        if (isInvokingGetMessage) {
            this.getStack().getStackItem(0).setSpecialKind(this.isMessage);
        }
    }

    private boolean isInvokingGetMessage(int seen) {
        return seen == 182 && this.getThrowableHandler().checkThrowable(this.getStack().getStackItem(0)) && (Objects.equal("getMessage", this.getNameConstantOperand()) || Objects.equal("getLocalizedMessage", this.getNameConstantOperand()));
    }

    @Override
    protected void onLog(@Nullable String format, @Nullable ArrayData arrayData) {
        if (arrayData == null || !arrayData.isMarked()) {
            return;
        }
        BugInstance bugInstance = new BugInstance((Detector)this, "SLF4J_MANUALLY_PROVIDED_MESSAGE", 2).addSourceLine((BytecodeScanningDetector)this).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this);
        this.getBugReporter().reportBug(bugInstance);
    }
}

