/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.findbugs.slf4j.parameter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jp.skypencil.findbugs.slf4j.parameter.ArrayData;
import jp.skypencil.findbugs.slf4j.parameter.ArrayDataHandler;
import jp.skypencil.findbugs.slf4j.parameter.ThrowableHandler;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public abstract class AbstractDetectorForParameterArray
extends OpcodeStackDetector {
    private static final ImmutableSet<String> TARGET_METHOD_NAMES = ImmutableSet.of("trace", "debug", "info", "warn", "error");
    private static final ImmutableSet<String> SIGS_WITHOUT_FORMAT = ImmutableSet.of("(Ljava/lang/String;)V", "(Lorg/slf4j/Maker;Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "(Lorg/slf4j/Maker;Ljava/lang/String;Ljava/lang/Throwable;)V");
    private static final Pattern SIGNATURE_PATTERN = Pattern.compile("^\\((.*)\\).*$");
    private Table<Method, Integer, List<BugInstance>> potentialBugs;
    private Multimap<String, Integer> calledWithNonConstants;
    private Table<String, Integer, List<Object>> calledWithConstants;
    private final BugReporter bugReporter;
    private final ThrowableHandler throwableHandler;
    private final ArrayDataHandler arrayDataHandler;

    public AbstractDetectorForParameterArray(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.throwableHandler = new ThrowableHandler();
        this.arrayDataHandler = new ArrayDataHandler(this.createArrayCheckStrategy());
    }

    protected abstract ArrayDataHandler.Strategy createArrayCheckStrategy();

    public void visitClassContext(ClassContext classContext) {
        this.potentialBugs = HashBasedTable.create();
        this.calledWithNonConstants = ArrayListMultimap.create();
        this.calledWithConstants = HashBasedTable.create();
        super.visitClassContext(classContext);
        this.validatePrivateMethodCall();
    }

    private void validatePrivateMethodCall() {
        for (Table.Cell<Method, Integer, List<BugInstance>> cell : this.potentialBugs.cellSet()) {
            Method method = cell.getRowKey();
            String methodSignature = method.getName() + method.getSignature();
            if (!this.calledWithNonConstants.containsEntry(methodSignature, cell.getColumnKey())) continue;
            for (BugInstance bug : cell.getValue()) {
                this.bugReporter.reportBug(bug);
            }
        }
    }

    public final void sawOpcode(int seen) {
        try {
            this.checkEvents(seen);
        }
        finally {
            this.arrayDataHandler.sawOpcode(this.getStack(), seen);
        }
    }

    private void checkEvents(int seen) {
        if (seen == 185) {
            if (!Objects.equal("org/slf4j/Logger", this.getClassConstantOperand()) || !TARGET_METHOD_NAMES.contains(this.getNameConstantOperand())) {
                return;
            }
            String signature = this.getSigConstantOperand();
            String formatString = this.findFormatString(signature);
            ArrayData arrayData = this.findArrayData(signature);
            this.onLog(formatString, arrayData);
        } else if (this.isMethodCall() && Objects.equal(this.getClassDescriptor().getClassName(), this.getClassConstantOperand())) {
            int shift;
            String methodSignature = this.getNameConstantOperand() + this.getSigConstantOperand();
            int arguments = Type.getArgumentTypes((String)this.getSigConstantOperand()).length;
            for (int i = shift = seen == 184 ? 0 : 1; i < arguments + shift; ++i) {
                OpcodeStack.Item item = this.getStack().getStackItem(i);
                if (item.getConstant() == null) {
                    this.calledWithNonConstants.put(methodSignature, i);
                    continue;
                }
                List<Object> list = this.calledWithConstants.get(methodSignature, i);
                if (list == null) {
                    list = Lists.newArrayList();
                    this.calledWithConstants.put(methodSignature, i, list);
                }
                list.add(item.getConstant());
            }
        }
    }

    @Nullable
    private ArrayData findArrayData(String signature) {
        int stackIndex = AbstractDetectorForParameterArray.indexOf(signature, "[Ljava/lang/Object;");
        if (stackIndex == -1) {
            String[] signatures = AbstractDetectorForParameterArray.splitSignature(signature);
            int parameterCount = signatures.length - 1;
            if (signatures[0].equals("Lorg/slf4j/Marker;")) {
                --parameterCount;
            }
            ArrayData data = new ArrayData(parameterCount);
            for (int i = 0; i < data.getSize(); ++i) {
                OpcodeStack.Item item = this.getStack().getStackItem(i);
                this.arrayDataHandler.store(item, data, parameterCount - 1 - i);
            }
            return data;
        }
        Object userValue = this.getStack().getStackItem(stackIndex).getUserValue();
        if (userValue instanceof ArrayData) {
            return (ArrayData)userValue;
        }
        return null;
    }

    @Nullable
    private String findFormatString(String signature) {
        int stackIndex = AbstractDetectorForParameterArray.indexOf(signature, "Ljava/lang/String;");
        OpcodeStack.Item item = this.getStack().getStackItem(stackIndex);
        Object constant = item.getConstant();
        if (constant == null) {
            BugInstance bug = new BugInstance((Detector)this, "SLF4J_FORMAT_SHOULD_BE_CONST", 1).addSourceLine((BytecodeScanningDetector)this).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this);
            int argumentIndexOfLogFormat = this.getArgumentIndexOfLogFormat();
            if (argumentIndexOfLogFormat == -1 || !this.getMethod().isPrivate()) {
                this.bugReporter.reportBug(bug);
                return null;
            }
            Method method = this.getMethod();
            List<BugInstance> storedList = this.potentialBugs.get(method, argumentIndexOfLogFormat);
            if (storedList == null) {
                storedList = Lists.newArrayList();
                this.potentialBugs.put(method, argumentIndexOfLogFormat, storedList);
            }
            storedList.add(bug);
            return null;
        }
        if (SIGS_WITHOUT_FORMAT.contains(signature)) {
            return null;
        }
        return constant.toString();
    }

    protected final int getArgumentIndexOfLogFormat() {
        int stackIndex = AbstractDetectorForParameterArray.indexOf(this.getSigConstantOperand(), "Ljava/lang/String;");
        OpcodeStack.Item item = this.getStack().getStackItem(stackIndex);
        int argumentIndex = item.getRegisterNumber();
        Method method = this.getMethod();
        if (argumentIndex != -1 && method.isStatic()) {
            ++argumentIndex;
        }
        return argumentIndex;
    }

    @VisibleForTesting
    static int indexOf(String methodSignature, String targetType) {
        String[] arguments = AbstractDetectorForParameterArray.splitSignature(methodSignature);
        int index = arguments.length;
        for (String type : arguments) {
            --index;
            if (!Objects.equal(type, targetType)) continue;
            return index;
        }
        return -1;
    }

    private static String[] splitSignature(String methodSignature) {
        Matcher matcher = SIGNATURE_PATTERN.matcher(methodSignature);
        if (matcher.find()) {
            String[] arguments = matcher.group(1).split(";");
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = arguments[i] + ';';
            }
            return arguments;
        }
        throw new IllegalArgumentException();
    }

    @OverridingMethodsMustInvokeSuper
    public void afterOpcode(int seen) {
        OpcodeStack stack = this.getStack();
        ArrayData newUserValueToSet = this.arrayDataHandler.afterOpcode(stack, seen, this.getClassName(), this.getPC());
        super.afterOpcode(seen);
        if (newUserValueToSet != null) {
            OpcodeStack.Item createdArray = stack.getStackItem(0);
            createdArray.setUserValue((Object)newUserValueToSet);
        }
    }

    protected final BugReporter getBugReporter() {
        return this.bugReporter;
    }

    protected final ThrowableHandler getThrowableHandler() {
        return this.throwableHandler;
    }

    protected final boolean isCalledWithNonConstants(Method method, Integer argumentIndex) {
        String methodSignature = method.getName() + method.getSignature();
        return this.calledWithNonConstants.containsEntry(methodSignature, argumentIndex);
    }

    @CheckForNull
    protected final List<Object> getConstantsToCall(Method method, Integer argumentIndex) {
        String methodSignature = method.getName() + method.getSignature();
        return this.calledWithConstants.get(methodSignature, argumentIndex);
    }

    protected void onLog(@Nullable String format, @Nullable ArrayData arrayData) {
    }
}

