/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mavenplugins.dbunit;

import java.io.IOException;
import java.sql.SQLException;
import net.sourceforge.mavenplugins.dbunit.DbUnitTool;
import org.apache.commons.lang.StringUtils;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseSequenceFilter;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.ext.mssql.InsertIdentityOperation;
import org.dbunit.operation.DatabaseOperation;

public class DataSetTool
extends DbUnitTool {
    private String dataSetFormat;
    private String operation;
    private DatabaseOperation dbOperation;
    private String exportTables;
    private static final String EXPORT = "EXPORT";
    private static final String EXCEL = "EXCEL";

    public String getDataSetFormat() {
        return this.dataSetFormat;
    }

    public void setDataSetFormat(String name) {
        this.dataSetFormat = name;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String name) {
        this.operation = name;
        if (this.operation == null) {
            this.operation = "INSERT";
        }
        if (this.operation.equalsIgnoreCase("CLEAN_INSERT")) {
            this.dbOperation = DatabaseOperation.CLEAN_INSERT;
        }
        if (this.operation.equalsIgnoreCase("DELETE")) {
            this.dbOperation = DatabaseOperation.DELETE;
        }
        if (this.operation.equalsIgnoreCase("INSERT")) {
            this.dbOperation = DatabaseOperation.INSERT;
        }
        if (this.operation.equalsIgnoreCase("MSSQL_CLEAN_INSERT")) {
            this.dbOperation = InsertIdentityOperation.CLEAN_INSERT;
        }
    }

    public String getExportTables() {
        return this.exportTables;
    }

    public void setExportTables(String tables) {
        this.exportTables = tables;
    }

    private IDataSet getDataSet(IDatabaseConnection connection) throws SQLException {
        IDataSet dataSet = null;
        if (this.getExportTables() == null) {
            dataSet = connection.createDataSet();
        } else {
            String[] tables = StringUtils.split((String)this.getExportTables(), (String)",");
            dataSet = connection.createDataSet(tables);
        }
        try {
            DatabaseSequenceFilter filter = new DatabaseSequenceFilter(connection);
            return new FilteredDataSet((ITableFilter)filter, dataSet);
        }
        catch (DataSetException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public void process() throws ClassNotFoundException, SQLException, IOException, DataSetException, DatabaseUnitException {
        if (this.getOperation().equalsIgnoreCase(EXPORT)) {
            IDatabaseConnection connection = this.getConnection();
            this.writeDataSetToFile(this.getFileName(), this.getDataSetFormat(), this.getDataSet(connection));
            connection.close();
        } else if (this.dbOperation != null) {
            IDataSet dataset = this.getDataSetFromFile(this.getFileName(), this.getDataSetFormat());
            this.dbOperation.execute(this.getConnection(), dataset);
        } else {
            throw new IllegalArgumentException("Invalid value for maven.dbunit.importType");
        }
    }
}

