/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mavenplugins.dbunit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.excel.XlsDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.XmlDataSet;

public class DbUnitTool {
    private String driverClassName;
    private String url;
    private String user;
    private String password;
    private String fileName;
    private String schema;

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String name) {
        this.driverClassName = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String newURL) {
        this.url = newURL;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String newUser) {
        this.user = newUser;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String newPassword) {
        this.password = newPassword;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String newFileName) {
        this.fileName = newFileName;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    protected IDatabaseConnection getConnection() throws SQLException, ClassNotFoundException {
        Class<?> driverClass = Class.forName(this.getDriverClassName());
        Connection jdbcConnection = DriverManager.getConnection(this.getUrl(), this.getUser(), this.getPassword());
        jdbcConnection.setAutoCommit(true);
        DatabaseConnection connection = null;
        connection = this.getSchema() == null ? new DatabaseConnection(jdbcConnection) : new DatabaseConnection(jdbcConnection, this.getSchema());
        return connection;
    }

    protected IDataSet getDataSetFromFile(String fileName, String format) throws DataSetException, IOException {
        XlsDataSet dataset = null;
        if ("EXCEL".equalsIgnoreCase(format)) {
            dataset = new XlsDataSet(new File(fileName));
        } else if ("XML".equalsIgnoreCase(format)) {
            dataset = new XmlDataSet((Reader)new FileReader(fileName));
        } else if ("FLAT".equalsIgnoreCase(format)) {
            dataset = new FlatXmlDataSet(new File(fileName));
        } else {
            throw new IllegalArgumentException("dataset of format '" + format + "' is not supported.");
        }
        return dataset;
    }

    protected void writeDataSetToFile(String fileName, String format, IDataSet dataset) throws DataSetException, FileNotFoundException, IOException {
        FileOutputStream stream = new FileOutputStream(fileName);
        if ("EXCEL".equalsIgnoreCase(format)) {
            XlsDataSet.write((IDataSet)dataset, (OutputStream)stream);
        } else if ("XML".equalsIgnoreCase(format)) {
            XmlDataSet.write((IDataSet)dataset, (OutputStream)stream);
        } else if ("FLAT".equalsIgnoreCase(format)) {
            FlatXmlDataSet.write((IDataSet)dataset, (OutputStream)stream);
        }
        stream.close();
    }
}

