/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz.matching;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.gosimple.nbvcxz.matching.PasswordMatcher;
import me.gosimple.nbvcxz.matching.match.DateMatch;
import me.gosimple.nbvcxz.matching.match.Match;
import me.gosimple.nbvcxz.resources.Configuration;

public final class DateMatcher
implements PasswordMatcher {
    private static final Pattern DATE_WITHOUT_SEPARATOR = Pattern.compile("^\\d{6,8}$");
    private static final Pattern DATE_WITH_SEPARATOR_YEAR_SUFFIX = Pattern.compile("^(\\d{1,2})(\\s|-|/|\\\\|_|\\.)(\\d{1,2})\\2(19\\d{2}|200\\d|201\\d|\\d{2})$");
    private static final Pattern DATE_WITH_SEPARATOR_YEAR_PREFIX = Pattern.compile("^(19\\d{2}|200\\d|201\\d|\\d{2})(\\s|-|/|\\\\|_|\\.)(\\d{1,2})\\2(\\d{1,2})$");

    private static ArrayList<DateMatch> matchDatesWithoutSeparator(Configuration configuration, String password) {
        ArrayList<DateMatch> dateMatches = new ArrayList<DateMatch>();
        for (int start = 0; start < password.length(); ++start) {
            for (int end = start + 4; end <= password.length(); ++end) {
                String passwordChunk = password.substring(start, end);
                if (!DATE_WITHOUT_SEPARATOR.matcher(passwordChunk).find()) continue;
                ArrayList<PartialDateSplit> possiblePartialSplit = new ArrayList<PartialDateSplit>();
                int chunkLength = passwordChunk.length();
                if (chunkLength <= 6) {
                    possiblePartialSplit.add(new PartialDateSplit(passwordChunk.substring(2), passwordChunk.substring(0, 2)));
                    possiblePartialSplit.add(new PartialDateSplit(passwordChunk.substring(0, chunkLength - 2), passwordChunk.substring(chunkLength - 2, chunkLength)));
                }
                if (chunkLength >= 6) {
                    possiblePartialSplit.add(new PartialDateSplit(passwordChunk.substring(4), passwordChunk.substring(0, 4)));
                    possiblePartialSplit.add(new PartialDateSplit(passwordChunk.substring(0, chunkLength - 4), passwordChunk.substring(chunkLength - 4, chunkLength)));
                }
                ArrayList<FullDateSplit> possibleFullSplit = new ArrayList<FullDateSplit>();
                for (PartialDateSplit partialDateSplit : possiblePartialSplit) {
                    int dateAndMonthLength = partialDateSplit.dateAndMonth.length();
                    if (dateAndMonthLength == 2) {
                        possibleFullSplit.add(new FullDateSplit(partialDateSplit.dateAndMonth.substring(0, 1), partialDateSplit.dateAndMonth.substring(1, 2), partialDateSplit.year));
                        continue;
                    }
                    if (dateAndMonthLength == 3) {
                        possibleFullSplit.add(new FullDateSplit(partialDateSplit.dateAndMonth.substring(0, 1), partialDateSplit.dateAndMonth.substring(1, 3), partialDateSplit.year));
                        possibleFullSplit.add(new FullDateSplit(partialDateSplit.dateAndMonth.substring(0, 2), partialDateSplit.dateAndMonth.substring(2, 3), partialDateSplit.year));
                        continue;
                    }
                    if (dateAndMonthLength != 4) continue;
                    possibleFullSplit.add(new FullDateSplit(partialDateSplit.dateAndMonth.substring(0, 2), partialDateSplit.dateAndMonth.substring(2, 4), partialDateSplit.year));
                }
                for (FullDateSplit fullDateSplit : possibleFullSplit) {
                    ValidDateSplit vSplit = DateMatcher.isDateValid(fullDateSplit.date, fullDateSplit.month, fullDateSplit.year);
                    if (vSplit == null) continue;
                    dateMatches.add(new DateMatch(passwordChunk, configuration, vSplit.date, vSplit.month, vSplit.year, "", start, end - 1));
                }
            }
        }
        return dateMatches;
    }

    private static ArrayList<DateMatch> matchDatesWithSeparator(Configuration configuration, String password) {
        ArrayList<DateMatch> dateMatches = new ArrayList<DateMatch>();
        for (int start = 0; start < password.length(); ++start) {
            for (int end = start + 6; end <= password.length(); ++end) {
                ValidDateSplit split;
                Matcher m2;
                ValidDateSplit split2;
                String passwordChunk = password.substring(start, end);
                Matcher m1 = DATE_WITH_SEPARATOR_YEAR_SUFFIX.matcher(passwordChunk);
                if (m1.matches() && (split2 = DateMatcher.isDateValid(m1.group(1), m1.group(3), m1.group(4))) != null) {
                    dateMatches.add(new DateMatch(passwordChunk, configuration, split2.date, split2.month, split2.year, m1.group(2), start, end - 1));
                }
                if (!(m2 = DATE_WITH_SEPARATOR_YEAR_PREFIX.matcher(passwordChunk)).matches() || (split = DateMatcher.isDateValid(m2.group(4), m2.group(3), m2.group(1))) == null) continue;
                dateMatches.add(new DateMatch(passwordChunk, configuration, split.date, split.month, split.year, m2.group(2), start, end - 1));
            }
        }
        return dateMatches;
    }

    private static ValidDateSplit isDateValid(String day, String month, String year) {
        try {
            int dayInt = Integer.parseInt(day);
            int monthInt = Integer.parseInt(month);
            int yearInt = Integer.parseInt(year);
            if (dayInt <= 0 || dayInt > 31 || monthInt <= 0 || monthInt > 12 || yearInt <= 0 || yearInt >= 100 && (yearInt < 1900 || yearInt > 2019)) {
                return null;
            }
            return new ValidDateSplit(dayInt, monthInt, yearInt);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public List<Match> match(Configuration configuration, String password) {
        ArrayList<Match> dateMatches = new ArrayList<Match>();
        dateMatches.addAll(DateMatcher.matchDatesWithoutSeparator(configuration, password));
        dateMatches.addAll(DateMatcher.matchDatesWithSeparator(configuration, password));
        return dateMatches;
    }

    private static class ValidDateSplit {
        public final int date;
        public final int month;
        public final int year;

        public ValidDateSplit(int date, int month, int year) {
            this.date = date;
            this.month = month;
            this.year = year;
        }
    }

    private static class FullDateSplit {
        public final String date;
        public final String month;
        public final String year;

        public FullDateSplit(String date, String month, String year) {
            this.date = date;
            this.month = month;
            this.year = year;
        }
    }

    private static class PartialDateSplit {
        public final String dateAndMonth;
        public final String year;

        public PartialDateSplit(String dateAndMonth, String year) {
            this.dateAndMonth = dateAndMonth;
            this.year = year;
        }
    }
}

