/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz.matching.match;

import java.util.ResourceBundle;
import me.gosimple.nbvcxz.matching.match.Match;
import me.gosimple.nbvcxz.resources.Configuration;

public abstract class BaseMatch
implements Match {
    protected static final double LOG_2 = Math.log(2.0);
    protected static final double LOG_10 = BaseMatch.log2(10.0);
    protected static final double LOG_26 = BaseMatch.log2(26.0);
    protected static final double LOG_129 = BaseMatch.log2(129.0);
    protected static final double LOG_37200 = BaseMatch.log2(37200.0);
    protected static final double LOG_47988 = BaseMatch.log2(47988.0);
    protected final Configuration configuration;
    private final String token;
    private final int start_index;
    private final int end_index;
    private double entropy;

    public BaseMatch(String match, Configuration configuration, int start_index, int end_index) {
        if (match == null) {
            throw new IllegalArgumentException("Null String");
        }
        if (match.isEmpty()) {
            throw new IllegalArgumentException("Empty String");
        }
        this.token = match;
        this.configuration = configuration;
        this.start_index = start_index;
        this.end_index = end_index;
    }

    protected static double log2(double value) {
        return Math.log(value) / LOG_2;
    }

    protected static long nCk(int n, int k) {
        if (k > n) {
            return 0L;
        }
        long result = 1L;
        for (int i = 1; i <= k; ++i) {
            result *= (long)n--;
            result /= (long)i;
        }
        return result;
    }

    protected void setEntropy(double entropy) {
        this.entropy = entropy;
    }

    @Override
    public final double calculateEntropy() {
        return Math.max(0.0, this.entropy);
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public int getStartIndex() {
        return this.start_index;
    }

    @Override
    public int getEndIndex() {
        return this.end_index;
    }

    @Override
    public int getLength() {
        return this.token.length();
    }

    @Override
    public String getDetails() {
        ResourceBundle mainResource = this.configuration.getMainResource();
        StringBuilder detailBuilder = new StringBuilder();
        detailBuilder.append(mainResource.getString("main.match.matchType")).append(" ").append(this.getClass().getSimpleName());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.entropy")).append(" ").append(this.calculateEntropy());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.token")).append(" ").append(this.getToken());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.startIndex")).append(" ").append(this.getStartIndex());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.endIndex")).append(" ").append(this.getEndIndex());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.length")).append(" ").append(this.getLength());
        return detailBuilder.toString();
    }
}

