/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz.resources;

import java.util.ArrayList;
import me.gosimple.nbvcxz.matching.match.DateMatch;
import me.gosimple.nbvcxz.matching.match.DictionaryMatch;
import me.gosimple.nbvcxz.matching.match.Match;
import me.gosimple.nbvcxz.matching.match.RepeatMatch;
import me.gosimple.nbvcxz.matching.match.SequenceMatch;
import me.gosimple.nbvcxz.matching.match.SpacialMatch;
import me.gosimple.nbvcxz.matching.match.YearMatch;
import me.gosimple.nbvcxz.resources.CharacterCaseUtil;
import me.gosimple.nbvcxz.resources.Configuration;
import me.gosimple.nbvcxz.resources.Dictionary;
import me.gosimple.nbvcxz.resources.Feedback;
import me.gosimple.nbvcxz.scoring.Result;

public class FeedbackUtil {
    public static Feedback getFeedback(Result result) {
        if (result.isMinimumEntropyMet()) {
            return new Feedback(result.getConfiguration(), "main.feedback.minimumMet");
        }
        if (result.getPassword().length() == 0) {
            return FeedbackUtil.getDefaultFeedback(result.getConfiguration());
        }
        Match longestMatch = null;
        for (Match match : result.getMatches()) {
            if (longestMatch == null) {
                longestMatch = match;
            }
            if (match.getLength() <= longestMatch.getLength()) continue;
            longestMatch = match;
        }
        return FeedbackUtil.getMatchFeedback(result, longestMatch);
    }

    private static Feedback getMatchFeedback(Result result, Match match) {
        Configuration configuration = result.getConfiguration();
        ArrayList<String> suggestions = new ArrayList<String>();
        if (match instanceof DateMatch) {
            return new Feedback(configuration, "main.feedback.insecure", "feedback.date.warning.dates", "feedback.date.suggestions.avoidDates", "feedback.extra.suggestions.addAnotherWord");
        }
        if (match instanceof YearMatch) {
            return new Feedback(configuration, "main.feedback.insecure", "feedback.year.warning.recentYears", "feedback.year.suggestions.avoidYears", "feedback.extra.suggestions.addAnotherWord");
        }
        if (match instanceof RepeatMatch && ((RepeatMatch)RepeatMatch.class.cast(match)).getRepeatingCharacters().length() == 1) {
            return new Feedback(configuration, "main.feedback.insecure", "feedback.repeat.warning.likeAAA", "feedback.repeat.suggestions.avoidRepeated", "feedback.extra.suggestions.addAnotherWord");
        }
        if (match instanceof RepeatMatch && ((RepeatMatch)RepeatMatch.class.cast(match)).getRepeatingCharacters().length() != 1) {
            return new Feedback(configuration, "main.feedback.insecure", "feedback.repeat.warning.likeABCABCABC", "feedback.repeat.suggestions.avoidRepeated", "feedback.extra.suggestions.addAnotherWord");
        }
        if (match instanceof SequenceMatch) {
            return new Feedback(configuration, "main.feedback.insecure", "feedback.sequence.warning.sequenceWarning", "feedback.sequence.suggestions.avoidSequences", "feedback.extra.suggestions.addAnotherWord");
        }
        if (match instanceof SpacialMatch) {
            if (((SpacialMatch)SpacialMatch.class.cast(match)).getTurns() > 0) {
                return new Feedback(configuration, "main.feedback.insecure", "feedback.spatial.warning.shortKeyboardPatterns", "feedback.spatial.suggestions.UseLongerKeyboardPattern", "feedback.extra.suggestions.addAnotherWord");
            }
            return new Feedback(configuration, "main.feedback.insecure", "feedback.spatial.warning.straightRowsOfKeys", "feedback.spatial.suggestions.UseLongerKeyboardPattern", "feedback.extra.suggestions.addAnotherWord");
        }
        if (match instanceof DictionaryMatch) {
            double capitalizationFraction;
            DictionaryMatch dictionaryMatch = (DictionaryMatch)DictionaryMatch.class.cast(match);
            String dictionaryName = dictionaryMatch.getDictionaryName();
            for (Dictionary dictionary : result.getConfiguration().getDictionaries()) {
                if (!dictionary.getDictionaryName().equals(dictionaryName) || !dictionary.isExclusion()) continue;
                return new Feedback(configuration, "main.feedback.insecure", "feedback.dictionary.warning.passwords.notAllowed", "feedback.dictionary.suggestions.passwords.notAllowed");
            }
            String warning = dictionaryMatch.getRank() <= 10 ? "feedback.dictionary.warning.passwords.top10" : (dictionaryMatch.getRank() <= 100 ? "feedback.dictionary.warning.passwords.top100" : "feedback.dictionary.warning.passwords.veryCommon");
            suggestions.add("feedback.extra.suggestions.addAnotherWord");
            if (dictionaryMatch.isReversed()) {
                suggestions.add("feedback.dictionary.suggestions.reversed");
            }
            if (dictionaryMatch.isLeet()) {
                suggestions.add("feedback.dictionary.suggestions.leet");
            }
            if ((capitalizationFraction = CharacterCaseUtil.fractionOfStringUppercase(result.getPassword())) > 0.8) {
                suggestions.add("feedback.dictionary.suggestions.allUppercase");
            } else if (capitalizationFraction > 0.0 && capitalizationFraction <= 0.2) {
                suggestions.add("feedback.dictionary.suggestions.capitalization");
            }
            return new Feedback(configuration, "main.feedback.insecure", warning, suggestions.toArray(new String[suggestions.size()]));
        }
        return FeedbackUtil.getDefaultFeedback(configuration);
    }

    private static Feedback getDefaultFeedback(Configuration configuration) {
        return new Feedback(configuration, "main.feedback.insecure", "feedback.default.suggestions.useFewWords", "feedback.default.suggestions.noNeedSymbols");
    }
}

