/*
 * Decompiled with CFR 0.152.
 */
package me.jvt.cucumber.report.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.presentation.PresentationMode;
import net.masterthought.cucumber.reducers.ReducingMethod;
import net.masterthought.cucumber.sorting.SortingMethod;
import org.apache.commons.lang3.StringUtils;

public class ConfigurationFactory {
    private static final String DEFAULT_FILENAME = "cucumber-reporting.properties";
    private static final String TAGS_TO_EXCLUDE_FROM_CHART_PATTERN = "^tagsToExcludeFromChart\\.\\d+$";
    private static final String PRESENTATION_MODE_PREFIX = "presentationMode.";
    private static final String REDUCING_METHOD_PREFIX = "reducingMethod.";
    private static final String CLASSIFICATIONS_PREFIX = "classifications.";
    public static final String CONFIG_FILE_PROPERTY = "cucumber.reporting.config.file";

    public static Configuration getConfiguration(File outputDir) {
        Properties properties = ConfigurationFactory.loadProperties();
        String projectName = properties.getProperty("projectName", "No Name (add projectName to cucumber-reporting.properties)");
        Configuration configuration = new Configuration(outputDir, projectName);
        ConfigurationFactory.configureBuildNumber(configuration, properties);
        ConfigurationFactory.configureSortingMethod(configuration, properties);
        ConfigurationFactory.configureTagsToExcludeFromChart(configuration, properties);
        ConfigurationFactory.configureTrendsStatsFile(configuration, properties);
        ConfigurationFactory.configureRepeatableConfigurationKeys(configuration, properties);
        return configuration;
    }

    protected static void configureBuildNumber(Configuration configuration, Properties properties) {
        configuration.setBuildNumber(properties.getProperty("buildNumber"));
    }

    protected static void configureSortingMethod(Configuration configuration, Properties properties) {
        String sortingMethod = properties.getProperty("sortingMethod");
        if (StringUtils.isNotEmpty((CharSequence)sortingMethod)) {
            configuration.setSortingMethod(Enum.valueOf(SortingMethod.class, sortingMethod));
        }
    }

    protected static void configureTagsToExcludeFromChart(Configuration configuration, Properties properties) {
        String[] tagsToExclude = ConfigurationFactory.getTagsToExcludeFromChart(properties);
        configuration.setTagsToExcludeFromChart(tagsToExclude);
    }

    protected static String[] getTagsToExcludeFromChart(Properties properties) {
        return (String[])properties.entrySet().stream().filter(entry -> ((String)entry.getKey()).matches(TAGS_TO_EXCLUDE_FROM_CHART_PATTERN)).map(Map.Entry::getValue).toArray(String[]::new);
    }

    protected static void configureTrendsStatsFile(Configuration configuration, Properties properties) {
        String trendsStatsFile = properties.getProperty("trendsStatsFile");
        if (StringUtils.isNotEmpty((CharSequence)trendsStatsFile)) {
            configuration.setTrendsStatsFile(new File(trendsStatsFile));
        }
    }

    protected static void configureRepeatableConfigurationKeys(Configuration configuration, Properties properties) {
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String qualifiedKey = (String)keys.nextElement();
            if (qualifiedKey.startsWith(PRESENTATION_MODE_PREFIX)) {
                ConfigurationFactory.configurePresentationMode(qualifiedKey, configuration, properties);
                continue;
            }
            if (qualifiedKey.startsWith(REDUCING_METHOD_PREFIX)) {
                ConfigurationFactory.configureReducingMethod(qualifiedKey, configuration, properties);
                continue;
            }
            if (!qualifiedKey.startsWith(CLASSIFICATIONS_PREFIX)) continue;
            ConfigurationFactory.configureClassifications(qualifiedKey, configuration, properties);
        }
    }

    protected static void configurePresentationMode(String qualifiedKey, Configuration configuration, Properties properties) {
        if (Boolean.parseBoolean(properties.getProperty(qualifiedKey))) {
            String presentationModeName = qualifiedKey.substring(PRESENTATION_MODE_PREFIX.length());
            PresentationMode presentationMode = Enum.valueOf(PresentationMode.class, presentationModeName);
            configuration.addPresentationModes(presentationMode);
        }
    }

    protected static void configureReducingMethod(String qualifiedKey, Configuration configuration, Properties properties) {
        if (Boolean.parseBoolean(properties.getProperty(qualifiedKey))) {
            String reducingMethodName = qualifiedKey.substring(REDUCING_METHOD_PREFIX.length());
            ReducingMethod reducingMethod = Enum.valueOf(ReducingMethod.class, reducingMethodName);
            configuration.addReducingMethod(reducingMethod);
        }
    }

    protected static void configureClassifications(String qualifiedKey, Configuration configuration, Properties properties) {
        String key = qualifiedKey.substring(CLASSIFICATIONS_PREFIX.length());
        configuration.addClassifications(key, properties.getProperty(qualifiedKey));
    }

    protected static Properties loadProperties() {
        Properties properties = new Properties();
        InputStream stream = ConfigurationFactory.getPropertiesStream();
        if (stream != null) {
            try {
                properties.load(new InputStreamReader(stream, "UTF-8"));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return properties;
    }

    protected static InputStream getPropertiesStream() {
        String filename = ConfigurationFactory.getPropertiesFilename();
        File propertiesFile = Optional.ofNullable(Paths.get(filename, new String[0]).toFile()).filter(File::exists).filter(File::isFile).filter(File::canRead).orElse(null);
        if (propertiesFile == null && !filename.equals(DEFAULT_FILENAME)) {
            throw new UncheckedIOException(new FileNotFoundException("Cucumber reporting properties file " + filename + " was not found"));
        }
        if (propertiesFile != null) {
            try {
                return new FileInputStream(propertiesFile);
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException(e);
            }
        }
        return null;
    }

    protected static String getPropertiesFilename() {
        return System.getProperty(CONFIG_FILE_PROPERTY, DEFAULT_FILENAME);
    }
}

