/*
 * Decompiled with CFR 0.152.
 */
package me.moocar.logback.net;

import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.net.DefaultSocketConnector;
import ch.qos.logback.core.net.SocketConnector;
import ch.qos.logback.core.util.CloseUtil;
import ch.qos.logback.core.util.Duration;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;

public class SocketEncoderAppender<E>
extends OutputStreamAppender<E>
implements SocketConnector.ExceptionHandler {
    private static final int DEFAULT_ACCEPT_CONNECTION_DELAY = 1000;
    private static final int DEFAULT_EVENT_DELAY_TIMEOUT = 100;
    public static final int DEFAULT_QUEUE_SIZE = 128;
    private static final String DEFAULT_REMOTE_HOST = "localhost";
    private int port;
    private String remoteHost = "localhost";
    private InetAddress address;
    private int acceptConnectionTimeout = 1000;
    private String peerId;
    private SocketConnector connector;
    private Future<?> task;
    private int queueSize = 128;
    private BlockingDeque<E> deque;
    private Duration eventDelayLimit = new Duration(100L);
    private volatile Socket socket;

    public void start() {
        if (this.isStarted()) {
            return;
        }
        int errorCount = 0;
        if (this.port <= 0) {
            ++errorCount;
            this.addError("No port was configured for appender" + this.name);
        }
        if (this.remoteHost == null) {
            ++errorCount;
            this.addError("No remote host was configured for appender" + this.name);
        }
        if (errorCount == 0) {
            try {
                this.address = InetAddress.getByName(this.remoteHost);
            }
            catch (UnknownHostException ex) {
                this.addError("unknown host: " + this.remoteHost);
                ++errorCount;
            }
        }
        final FutureTask<Boolean> connectionFuture = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return true;
            }
        });
        if (errorCount == 0) {
            this.deque = new LinkedBlockingDeque(this.queueSize);
            this.peerId = "remote peer " + this.remoteHost + ":" + this.port + ": ";
            this.connector = this.createConnector(this.address, this.port, 0, 1000L);
            this.task = this.getContext().getExecutorService().submit(new Runnable(){

                @Override
                public void run() {
                    SocketEncoderAppender.this.connectSocketAndDispatchEvents(connectionFuture);
                }
            });
        }
        try {
            connectionFuture.get();
            super.start();
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        CloseUtil.closeQuietly((Socket)this.socket);
        this.task.cancel(true);
        super.stop();
    }

    private SocketConnector createConnector(InetAddress address, int port, int initialDelay, long retryDelay) {
        SocketConnector connector = this.newConnector(address, port, initialDelay, retryDelay);
        connector.setExceptionHandler((SocketConnector.ExceptionHandler)this);
        connector.setSocketFactory(this.getSocketFactory());
        return connector;
    }

    protected SocketConnector newConnector(InetAddress address, int port, long initialDelay, long retryDelay) {
        return new DefaultSocketConnector(address, port, initialDelay, retryDelay);
    }

    protected SocketFactory getSocketFactory() {
        return SocketFactory.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectSocketAndDispatchEvents(FutureTask<Boolean> connectionFuture) {
        try {
            while (this.socketConnectionCouldBeEstablished()) {
                try {
                    this.socket.setSoTimeout(this.acceptConnectionTimeout);
                    this.setOutputStream(this.socket.getOutputStream());
                    connectionFuture.run();
                    this.addInfo(this.peerId + "connection established");
                    this.dispatchEvents();
                }
                catch (IOException ex) {
                    this.addInfo(this.peerId + "connection failed: " + ex);
                }
                catch (Exception e) {
                    this.addError("Error in connect loop", e);
                }
                finally {
                    CloseUtil.closeQuietly((Socket)this.socket);
                    this.socket = null;
                    super.closeOutputStream();
                    this.addInfo(this.peerId + "connection closed");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.addInfo("shutting down");
    }

    private void dispatchEvents() throws InterruptedException, IOException {
        while (true) {
            E event = this.deque.takeFirst();
            super.subAppend(event);
            this.getOutputStream().write(0);
        }
    }

    protected void subAppend(E event) {
        if (event == null || !this.isStarted()) {
            return;
        }
        try {
            boolean inserted = this.deque.offer(event, this.eventDelayLimit.getMilliseconds(), TimeUnit.MILLISECONDS);
            if (!inserted) {
                this.addInfo("Dropping event due to timeout limit of [" + this.eventDelayLimit + "] being exceeded");
            }
        }
        catch (InterruptedException e) {
            this.addError("Interrupted while appending event to SocketAppender", e);
        }
    }

    private boolean socketConnectionCouldBeEstablished() throws InterruptedException {
        this.socket = this.connector.call();
        return this.socket != null;
    }

    public void connectionFailed(SocketConnector socketConnector, Exception ex) {
        if (ex instanceof InterruptedException) {
            this.addInfo("connector interrupted");
        } else if (ex instanceof ConnectException) {
            this.addInfo(this.peerId + "connection refused");
        } else {
            this.addInfo(this.peerId + ex);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getAcceptConnectionTimeout() {
        return this.acceptConnectionTimeout;
    }

    public void setAcceptConnectionTimeout(int acceptConnectionTimeout) {
        this.acceptConnectionTimeout = acceptConnectionTimeout;
    }
}

