/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.tiff;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import mil.nga.tiff.FieldTagType;
import mil.nga.tiff.FieldType;
import mil.nga.tiff.FileDirectoryEntry;
import mil.nga.tiff.ImageWindow;
import mil.nga.tiff.Rasters;
import mil.nga.tiff.compression.CompressionDecoder;
import mil.nga.tiff.compression.DeflateCompression;
import mil.nga.tiff.compression.LZWCompression;
import mil.nga.tiff.compression.PackbitsCompression;
import mil.nga.tiff.compression.RawCompression;
import mil.nga.tiff.compression.UnsupportedCompression;
import mil.nga.tiff.io.ByteReader;
import mil.nga.tiff.util.TiffException;

public class FileDirectory {
    private final SortedSet<FileDirectoryEntry> entries;
    private final Map<FieldTagType, FileDirectoryEntry> fieldTagTypeMapping = new HashMap<FieldTagType, FileDirectoryEntry>();
    private ByteReader reader;
    private boolean tiled;
    private int planarConfiguration;
    private CompressionDecoder decoder;
    private Map<Integer, byte[]> cache = null;
    private Rasters writeRasters = null;
    private int lastBlockIndex = -1;
    private byte[] lastBlock;

    public FileDirectory(SortedSet<FileDirectoryEntry> entries, ByteReader reader) {
        this(entries, reader, false);
    }

    public FileDirectory(SortedSet<FileDirectoryEntry> entries, ByteReader reader, boolean cacheData) {
        this.entries = entries;
        for (FileDirectoryEntry entry : entries) {
            this.fieldTagTypeMapping.put(entry.getFieldTag(), entry);
        }
        this.reader = reader;
        this.setCache(cacheData);
        this.tiled = this.getRowsPerStrip() == null;
        Integer pc = this.getPlanarConfiguration();
        int n = this.planarConfiguration = pc != null ? pc : 1;
        if (this.planarConfiguration != 1 && this.planarConfiguration != 2) {
            throw new TiffException("Invalid planar configuration: " + this.planarConfiguration);
        }
        Integer compression = this.getCompression();
        if (compression == null) {
            compression = 1;
        }
        switch (compression) {
            case 1: {
                this.decoder = new RawCompression();
                break;
            }
            case 2: {
                this.decoder = new UnsupportedCompression("CCITT Huffman compression not supported: " + compression);
                break;
            }
            case 3: {
                this.decoder = new UnsupportedCompression("T4-encoding compression not supported: " + compression);
                break;
            }
            case 4: {
                this.decoder = new UnsupportedCompression("T6-encoding compression not supported: " + compression);
                break;
            }
            case 5: {
                this.decoder = new LZWCompression();
                break;
            }
            case 6: 
            case 7: {
                this.decoder = new UnsupportedCompression("JPEG compression not supported: " + compression);
                break;
            }
            case 8: 
            case 32946: {
                this.decoder = new DeflateCompression();
                break;
            }
            case 32773: {
                this.decoder = new PackbitsCompression();
                break;
            }
            default: {
                this.decoder = new UnsupportedCompression("Unknown compression method identifier: " + compression);
            }
        }
    }

    public FileDirectory() {
        this(null);
    }

    public FileDirectory(Rasters rasters) {
        this(new TreeSet<FileDirectoryEntry>(), rasters);
    }

    public FileDirectory(SortedSet<FileDirectoryEntry> entries, Rasters rasters) {
        this.entries = entries;
        for (FileDirectoryEntry entry : entries) {
            this.fieldTagTypeMapping.put(entry.getFieldTag(), entry);
        }
        this.writeRasters = rasters;
    }

    public void addEntry(FileDirectoryEntry entry) {
        this.entries.remove(entry);
        this.entries.add(entry);
        this.fieldTagTypeMapping.put(entry.getFieldTag(), entry);
    }

    public void setCache(boolean cacheData) {
        if (cacheData) {
            if (this.cache == null) {
                this.cache = new HashMap<Integer, byte[]>();
            }
        } else {
            this.cache = null;
        }
    }

    public ByteReader getReader() {
        return this.reader;
    }

    public boolean isTiled() {
        return this.tiled;
    }

    public CompressionDecoder getDecoder() {
        return this.decoder;
    }

    public int numEntries() {
        return this.entries.size();
    }

    public FileDirectoryEntry get(FieldTagType fieldTagType) {
        return this.fieldTagTypeMapping.get((Object)fieldTagType);
    }

    public Set<FileDirectoryEntry> getEntries() {
        return Collections.unmodifiableSet(this.entries);
    }

    public Map<FieldTagType, FileDirectoryEntry> getFieldTagTypeMapping() {
        return Collections.unmodifiableMap(this.fieldTagTypeMapping);
    }

    public Number getImageWidth() {
        return this.getNumberEntryValue(FieldTagType.ImageWidth);
    }

    public void setImageWidth(int width) {
        this.setUnsignedIntegerEntryValue(FieldTagType.ImageWidth, width);
    }

    public void setImageWidthAsLong(long width) {
        this.setUnsignedLongEntryValue(FieldTagType.ImageWidth, width);
    }

    public Number getImageHeight() {
        return this.getNumberEntryValue(FieldTagType.ImageLength);
    }

    public void setImageHeight(int height) {
        this.setUnsignedIntegerEntryValue(FieldTagType.ImageLength, height);
    }

    public void setImageHeightAsLong(long height) {
        this.setUnsignedLongEntryValue(FieldTagType.ImageLength, height);
    }

    public List<Integer> getBitsPerSample() {
        return this.getIntegerListEntryValue(FieldTagType.BitsPerSample);
    }

    public void setBitsPerSample(List<Integer> bitsPerSample) {
        this.setUnsignedIntegerListEntryValue(FieldTagType.BitsPerSample, bitsPerSample);
    }

    public void setBitsPerSample(int bitsPerSample) {
        this.setBitsPerSample(this.createSingleIntegerList(bitsPerSample));
    }

    public Integer getMaxBitsPerSample() {
        return this.getMaxIntegerEntryValue(FieldTagType.BitsPerSample);
    }

    public Integer getCompression() {
        return this.getIntegerEntryValue(FieldTagType.Compression);
    }

    public void setCompression(int compression) {
        this.setUnsignedIntegerEntryValue(FieldTagType.Compression, compression);
    }

    public Integer getPhotometricInterpretation() {
        return this.getIntegerEntryValue(FieldTagType.PhotometricInterpretation);
    }

    public void setPhotometricInterpretation(int photometricInterpretation) {
        this.setUnsignedIntegerEntryValue(FieldTagType.PhotometricInterpretation, photometricInterpretation);
    }

    public List<Number> getStripOffsets() {
        return this.getNumberListEntryValue(FieldTagType.StripOffsets);
    }

    public void setStripOffsets(List<Integer> stripOffsets) {
        this.setUnsignedIntegerListEntryValue(FieldTagType.StripOffsets, stripOffsets);
    }

    public void setStripOffsetsAsLongs(List<Long> stripOffsets) {
        this.setUnsignedLongListEntryValue(FieldTagType.StripOffsets, stripOffsets);
    }

    public void setStripOffsets(int stripOffset) {
        this.setStripOffsets(this.createSingleIntegerList(stripOffset));
    }

    public void setStripOffsets(long stripOffset) {
        this.setStripOffsetsAsLongs(this.createSingleLongList(stripOffset));
    }

    public int getSamplesPerPixel() {
        Integer samplesPerPixel = this.getIntegerEntryValue(FieldTagType.SamplesPerPixel);
        if (samplesPerPixel == null) {
            samplesPerPixel = 1;
        }
        return samplesPerPixel;
    }

    public void setSamplesPerPixel(int samplesPerPixel) {
        this.setUnsignedIntegerEntryValue(FieldTagType.SamplesPerPixel, samplesPerPixel);
    }

    public Number getRowsPerStrip() {
        return this.getNumberEntryValue(FieldTagType.RowsPerStrip);
    }

    public void setRowsPerStrip(int rowsPerStrip) {
        this.setUnsignedIntegerEntryValue(FieldTagType.RowsPerStrip, rowsPerStrip);
    }

    public void setRowsPerStripAsLong(long rowsPerStrip) {
        this.setUnsignedLongEntryValue(FieldTagType.RowsPerStrip, rowsPerStrip);
    }

    public List<Number> getStripByteCounts() {
        return this.getNumberListEntryValue(FieldTagType.StripByteCounts);
    }

    public void setStripByteCounts(List<Integer> stripByteCounts) {
        this.setUnsignedIntegerListEntryValue(FieldTagType.StripByteCounts, stripByteCounts);
    }

    public void setStripByteCountsAsLongs(List<Long> stripByteCounts) {
        this.setUnsignedLongListEntryValue(FieldTagType.StripByteCounts, stripByteCounts);
    }

    public void setStripByteCounts(int stripByteCount) {
        this.setStripByteCounts(this.createSingleIntegerList(stripByteCount));
    }

    public void setStripByteCounts(long stripByteCount) {
        this.setStripByteCountsAsLongs(this.createSingleLongList(stripByteCount));
    }

    public List<Long> getXResolution() {
        return this.getLongListEntryValue(FieldTagType.XResolution);
    }

    public void setXResolution(List<Long> xResolution) {
        this.setRationalEntryValue(FieldTagType.XResolution, xResolution);
    }

    public void setXResolution(long xResolution) {
        this.setXResolution(this.createRationalValue(xResolution));
    }

    public List<Long> getYResolution() {
        return this.getLongListEntryValue(FieldTagType.YResolution);
    }

    public void setYResolution(List<Long> yResolution) {
        this.setRationalEntryValue(FieldTagType.YResolution, yResolution);
    }

    public void setYResolution(long yResolution) {
        this.setYResolution(this.createRationalValue(yResolution));
    }

    public Integer getPlanarConfiguration() {
        return this.getIntegerEntryValue(FieldTagType.PlanarConfiguration);
    }

    public void setPlanarConfiguration(int planarConfiguration) {
        this.setUnsignedIntegerEntryValue(FieldTagType.PlanarConfiguration, planarConfiguration);
    }

    public Integer getResolutionUnit() {
        return this.getIntegerEntryValue(FieldTagType.ResolutionUnit);
    }

    public void setResolutionUnit(int resolutionUnit) {
        this.setUnsignedIntegerEntryValue(FieldTagType.ResolutionUnit, resolutionUnit);
    }

    public List<Integer> getColorMap() {
        return this.getIntegerListEntryValue(FieldTagType.ColorMap);
    }

    public void setColorMap(List<Integer> colorMap) {
        this.setUnsignedIntegerListEntryValue(FieldTagType.ColorMap, colorMap);
    }

    public void setColorMap(int colorMap) {
        this.setColorMap(this.createSingleIntegerList(colorMap));
    }

    public Number getTileWidth() {
        return this.tiled ? (Number)this.getNumberEntryValue(FieldTagType.TileWidth) : (Number)this.getImageWidth();
    }

    public void setTileWidth(int tileWidth) {
        this.setUnsignedIntegerEntryValue(FieldTagType.TileWidth, tileWidth);
    }

    public void setTileWidthAsLong(long tileWidth) {
        this.setUnsignedLongEntryValue(FieldTagType.TileWidth, tileWidth);
    }

    public Number getTileHeight() {
        return this.tiled ? (Number)this.getNumberEntryValue(FieldTagType.TileLength) : (Number)this.getRowsPerStrip();
    }

    public void setTileHeight(int tileHeight) {
        this.setUnsignedIntegerEntryValue(FieldTagType.TileLength, tileHeight);
    }

    public void setTileHeightAsLong(long tileHeight) {
        this.setUnsignedLongEntryValue(FieldTagType.TileLength, tileHeight);
    }

    public List<Long> getTileOffsets() {
        return this.getLongListEntryValue(FieldTagType.TileOffsets);
    }

    public void setTileOffsets(List<Long> tileOffsets) {
        this.setUnsignedLongListEntryValue(FieldTagType.TileOffsets, tileOffsets);
    }

    public void setTileOffsets(long tileOffset) {
        this.setTileOffsets(this.createSingleLongList(tileOffset));
    }

    public List<Number> getTileByteCounts() {
        return this.getNumberListEntryValue(FieldTagType.TileByteCounts);
    }

    public void setTileByteCounts(List<Integer> tileByteCounts) {
        this.setUnsignedIntegerListEntryValue(FieldTagType.TileByteCounts, tileByteCounts);
    }

    public void setTileByteCountsAsLongs(List<Long> tileByteCounts) {
        this.setUnsignedLongListEntryValue(FieldTagType.TileByteCounts, tileByteCounts);
    }

    public void setTileByteCounts(int tileByteCount) {
        this.setTileByteCounts(this.createSingleIntegerList(tileByteCount));
    }

    public void setTileByteCounts(long tileByteCount) {
        this.setTileByteCountsAsLongs(this.createSingleLongList(tileByteCount));
    }

    public List<Integer> getSampleFormat() {
        return this.getIntegerListEntryValue(FieldTagType.SampleFormat);
    }

    public void setSampleFormat(List<Integer> sampleFormat) {
        this.setUnsignedIntegerListEntryValue(FieldTagType.SampleFormat, sampleFormat);
    }

    public void setSampleFormat(int sampleFormat) {
        this.setSampleFormat(this.createSingleIntegerList(sampleFormat));
    }

    public Integer getMaxSampleFormat() {
        return this.getMaxIntegerEntryValue(FieldTagType.SampleFormat);
    }

    public Rasters getWriteRasters() {
        return this.writeRasters;
    }

    public void setWriteRasters(Rasters rasters) {
        this.writeRasters = rasters;
    }

    public Rasters readRasters() {
        ImageWindow window = new ImageWindow(this);
        return this.readRasters(window);
    }

    public Rasters readInterleavedRasters() {
        ImageWindow window = new ImageWindow(this);
        return this.readInterleavedRasters(window);
    }

    public Rasters readRasters(ImageWindow window) {
        return this.readRasters(window, null);
    }

    public Rasters readInterleavedRasters(ImageWindow window) {
        return this.readInterleavedRasters(window, null);
    }

    public Rasters readRasters(int[] samples) {
        ImageWindow window = new ImageWindow(this);
        return this.readRasters(window, samples);
    }

    public Rasters readInterleavedRasters(int[] samples) {
        ImageWindow window = new ImageWindow(this);
        return this.readInterleavedRasters(window, samples);
    }

    public Rasters readRasters(ImageWindow window, int[] samples) {
        return this.readRasters(window, samples, true, false);
    }

    public Rasters readInterleavedRasters(ImageWindow window, int[] samples) {
        return this.readRasters(window, samples, false, true);
    }

    public Rasters readRasters(boolean sampleValues, boolean interleaveValues) {
        ImageWindow window = new ImageWindow(this);
        return this.readRasters(window, sampleValues, interleaveValues);
    }

    public Rasters readRasters(ImageWindow window, boolean sampleValues, boolean interleaveValues) {
        return this.readRasters(window, null, sampleValues, interleaveValues);
    }

    public Rasters readRasters(int[] samples, boolean sampleValues, boolean interleaveValues) {
        ImageWindow window = new ImageWindow(this);
        return this.readRasters(window, samples, sampleValues, interleaveValues);
    }

    public Rasters readRasters(ImageWindow window, int[] samples, boolean sampleValues, boolean interleaveValues) {
        int i;
        int width = this.getImageWidth().intValue();
        int height = this.getImageHeight().intValue();
        if (window.getMinX() < 0 || window.getMinY() < 0 || window.getMaxX() > width || window.getMaxY() > height) {
            throw new TiffException("Window is out of the image bounds. Width: " + width + ", Height: " + height + ", Window: " + window);
        }
        if (window.getMinX() > window.getMaxX() || window.getMinY() > window.getMaxY()) {
            throw new TiffException("Invalid window range: " + window);
        }
        int windowWidth = window.getMaxX() - window.getMinX();
        int windowHeight = window.getMaxY() - window.getMinY();
        int numPixels = windowWidth * windowHeight;
        int samplesPerPixel = this.getSamplesPerPixel();
        if (samples == null) {
            samples = new int[samplesPerPixel];
            for (i = 0; i < samples.length; ++i) {
                samples[i] = i;
            }
        } else {
            for (i = 0; i < samples.length; ++i) {
                if (samples[i] < samplesPerPixel) continue;
                throw new TiffException("Invalid sample index: " + samples[i]);
            }
        }
        List<Integer> bitsPerSample = this.getBitsPerSample();
        int bytesPerPixel = 0;
        for (int i2 = 0; i2 < samplesPerPixel; ++i2) {
            bytesPerPixel += bitsPerSample.get(i2) / 8;
        }
        ByteBuffer interleave = null;
        if (interleaveValues) {
            interleave = ByteBuffer.allocateDirect(numPixels * bytesPerPixel);
            interleave.order(this.reader.getByteOrder());
        }
        ByteBuffer[] sample = null;
        if (sampleValues) {
            sample = new ByteBuffer[samplesPerPixel];
            for (int i3 = 0; i3 < sample.length; ++i3) {
                sample[i3] = ByteBuffer.allocateDirect(numPixels * bitsPerSample.get(i3) / 8);
                sample[i3].order(this.reader.getByteOrder());
            }
        }
        FieldType[] fieldTypes = new FieldType[samples.length];
        for (int i4 = 0; i4 < samples.length; ++i4) {
            fieldTypes[i4] = this.getFieldTypeForSample(samples[i4]);
        }
        Rasters rasters = new Rasters(windowWidth, windowHeight, fieldTypes, sample, interleave);
        this.readRaster(window, samples, rasters);
        return rasters;
    }

    private void readRaster(ImageWindow window, int[] samples, Rasters rasters) {
        int tileWidth = this.getTileWidth().intValue();
        int tileHeight = this.getTileHeight().intValue();
        int minXTile = window.getMinX() / tileWidth;
        int maxXTile = (window.getMaxX() + tileWidth - 1) / tileWidth;
        int minYTile = window.getMinY() / tileHeight;
        int maxYTile = (window.getMaxY() + tileHeight - 1) / tileHeight;
        int windowWidth = window.getMaxX() - window.getMinX();
        int bytesPerPixel = this.getBytesPerPixel();
        int[] srcSampleOffsets = new int[samples.length];
        FieldType[] sampleFieldTypes = new FieldType[samples.length];
        for (int i = 0; i < samples.length; ++i) {
            int sampleOffset = 0;
            if (this.planarConfiguration == 1) {
                sampleOffset = this.sum(this.getBitsPerSample(), 0, samples[i]) / 8;
            }
            srcSampleOffsets[i] = sampleOffset;
            sampleFieldTypes[i] = this.getFieldTypeForSample(samples[i]);
        }
        for (int yTile = minYTile; yTile < maxYTile; ++yTile) {
            for (int xTile = minXTile; xTile < maxXTile; ++xTile) {
                int firstLine = yTile * tileHeight;
                int firstCol = xTile * tileWidth;
                int lastLine = (yTile + 1) * tileHeight;
                int lastCol = (xTile + 1) * tileWidth;
                for (int sampleIndex = 0; sampleIndex < samples.length; ++sampleIndex) {
                    int sample = samples[sampleIndex];
                    if (this.planarConfiguration == 2) {
                        bytesPerPixel = this.getSampleByteSize(sample);
                    }
                    byte[] block = this.getTileOrStrip(xTile, yTile, sample);
                    ByteReader blockReader = new ByteReader(block, this.reader.getByteOrder());
                    for (int y = Math.max(0, window.getMinY() - firstLine); y < Math.min(tileHeight, tileHeight - (lastLine - window.getMaxY())); ++y) {
                        for (int x = Math.max(0, window.getMinX() - firstCol); x < Math.min(tileWidth, tileWidth - (lastCol - window.getMaxX())); ++x) {
                            int windowCoordinate;
                            int pixelOffset = (y * tileWidth + x) * bytesPerPixel;
                            int valueOffset = pixelOffset + srcSampleOffsets[sampleIndex];
                            blockReader.setNextByte(valueOffset);
                            Number value = this.readValue(blockReader, sampleFieldTypes[sampleIndex]);
                            if (rasters.hasInterleaveValues()) {
                                windowCoordinate = (y + firstLine - window.getMinY()) * windowWidth + (x + firstCol - window.getMinX());
                                rasters.addToInterleave(sampleIndex, windowCoordinate, value);
                            }
                            if (!rasters.hasSampleValues()) continue;
                            windowCoordinate = (y + firstLine - window.getMinY()) * windowWidth + x + firstCol - window.getMinX();
                            rasters.addToSample(sampleIndex, windowCoordinate, value);
                        }
                    }
                }
            }
        }
    }

    private Number readValue(ByteReader reader, FieldType fieldType) {
        Number value = null;
        switch (fieldType) {
            case BYTE: {
                value = reader.readUnsignedByte();
                break;
            }
            case SHORT: {
                value = reader.readUnsignedShort();
                break;
            }
            case LONG: {
                value = reader.readUnsignedInt();
                break;
            }
            case SBYTE: {
                value = reader.readByte();
                break;
            }
            case SSHORT: {
                value = reader.readShort();
                break;
            }
            case SLONG: {
                value = reader.readInt();
                break;
            }
            case FLOAT: {
                value = Float.valueOf(reader.readFloat());
                break;
            }
            case DOUBLE: {
                value = reader.readDouble();
                break;
            }
            default: {
                throw new TiffException("Unsupported raster field type: " + (Object)((Object)fieldType));
            }
        }
        return value;
    }

    public FieldType getFieldTypeForSample(int sampleIndex) {
        List<Integer> sampleFormatList = this.getSampleFormat();
        int sampleFormat = sampleFormatList == null ? 1 : sampleFormatList.get(sampleIndex < sampleFormatList.size() ? sampleIndex : 0);
        int bitsPerSample = this.getBitsPerSample().get(sampleIndex);
        FieldType fieldType = FieldType.getFieldType(sampleFormat, bitsPerSample);
        return fieldType;
    }

    private byte[] getTileOrStrip(int x, int y, int sample) {
        byte[] tileOrStrip = null;
        int imageWidth = this.getImageWidth().intValue();
        int imageHeight = this.getImageHeight().intValue();
        int tileWidth = this.getTileWidth().intValue();
        int tileHeight = this.getTileHeight().intValue();
        int numTilesPerRow = (imageWidth + tileWidth - 1) / tileWidth;
        int numTilesPerCol = (imageHeight + tileHeight - 1) / tileHeight;
        int index = 0;
        if (this.planarConfiguration == 1) {
            index = y * numTilesPerRow + x;
        } else if (this.planarConfiguration == 2) {
            index = sample * numTilesPerRow * numTilesPerCol + y * numTilesPerRow + x;
        }
        if (this.cache != null && this.cache.containsKey(index)) {
            tileOrStrip = this.cache.get(index);
        } else if (this.lastBlockIndex == index && this.lastBlock != null) {
            tileOrStrip = this.lastBlock;
        } else {
            int offset = 0;
            int byteCount = 0;
            if (this.tiled) {
                offset = this.getTileOffsets().get(index).intValue();
                byteCount = this.getTileByteCounts().get(index).intValue();
            } else {
                offset = this.getStripOffsets().get(index).intValue();
                byteCount = this.getStripByteCounts().get(index).intValue();
            }
            this.reader.setNextByte(offset);
            byte[] bytes = this.reader.readBytes(byteCount);
            tileOrStrip = this.decoder.decode(bytes, this.reader.getByteOrder());
            if (this.cache != null) {
                this.cache.put(index, tileOrStrip);
            } else {
                this.lastBlockIndex = index;
                this.lastBlock = tileOrStrip;
            }
        }
        return tileOrStrip;
    }

    private int getSampleByteSize(int sampleIndex) {
        List<Integer> bitsPerSample = this.getBitsPerSample();
        if (sampleIndex >= bitsPerSample.size()) {
            throw new TiffException("Sample index " + sampleIndex + " is out of range");
        }
        int bits = bitsPerSample.get(sampleIndex);
        if (bits % 8 != 0) {
            throw new TiffException("Sample bit-width of " + bits + " is not supported");
        }
        return bits / 8;
    }

    private int getBytesPerPixel() {
        int bitsPerSample = 0;
        List<Integer> bitsPerSamples = this.getBitsPerSample();
        for (int i = 0; i < bitsPerSamples.size(); ++i) {
            int bits = bitsPerSamples.get(i);
            if (bits % 8 != 0) {
                throw new TiffException("Sample bit-width of " + bits + " is not supported");
            }
            if (bits != bitsPerSamples.get(0)) {
                throw new TiffException("Differing size of samples in a pixel are not supported. sample 0 = " + bitsPerSamples.get(0) + ", sample " + i + " = " + bits);
            }
            bitsPerSample += bits;
        }
        return bitsPerSample / 8;
    }

    public Integer getIntegerEntryValue(FieldTagType fieldTagType) {
        return (Integer)this.getEntryValue(fieldTagType);
    }

    public void setUnsignedIntegerEntryValue(FieldTagType fieldTagType, int value) {
        this.setEntryValue(fieldTagType, FieldType.SHORT, 1L, value);
    }

    public Number getNumberEntryValue(FieldTagType fieldTagType) {
        return (Number)this.getEntryValue(fieldTagType);
    }

    public void setUnsignedLongEntryValue(FieldTagType fieldTagType, long value) {
        this.setEntryValue(fieldTagType, FieldType.LONG, 1L, value);
    }

    public String getStringEntryValue(FieldTagType fieldTagType) {
        String value = null;
        List values = (List)this.getEntryValue(fieldTagType);
        if (values != null && !values.isEmpty()) {
            value = (String)values.get(0);
        }
        return value;
    }

    public void setStringEntryValue(FieldTagType fieldTagType, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.setEntryValue(fieldTagType, FieldType.ASCII, value.length() + 1, values);
    }

    public List<Integer> getIntegerListEntryValue(FieldTagType fieldTagType) {
        return (List)this.getEntryValue(fieldTagType);
    }

    public void setUnsignedIntegerListEntryValue(FieldTagType fieldTagType, List<Integer> value) {
        this.setEntryValue(fieldTagType, FieldType.SHORT, value.size(), value);
    }

    public Integer getMaxIntegerEntryValue(FieldTagType fieldTagType) {
        Integer maxValue = null;
        List<Integer> values = this.getIntegerListEntryValue(fieldTagType);
        if (values != null) {
            maxValue = Collections.max(values);
        }
        return maxValue;
    }

    public List<Number> getNumberListEntryValue(FieldTagType fieldTagType) {
        return (List)this.getEntryValue(fieldTagType);
    }

    public List<Long> getLongListEntryValue(FieldTagType fieldTagType) {
        return (List)this.getEntryValue(fieldTagType);
    }

    public void setUnsignedLongListEntryValue(FieldTagType fieldTagType, List<Long> value) {
        this.setEntryValue(fieldTagType, FieldType.LONG, value.size(), value);
    }

    public void setRationalEntryValue(FieldTagType fieldTagType, List<Long> value) {
        if (value == null || value.size() != 2) {
            throw new TiffException("Invalid rational value, must be two longs. Size: " + value.size());
        }
        this.setEntryValue(fieldTagType, FieldType.RATIONAL, 1L, value);
    }

    private <T> T getEntryValue(FieldTagType fieldTagType) {
        Object value = null;
        FileDirectoryEntry entry = this.fieldTagTypeMapping.get((Object)fieldTagType);
        if (entry != null) {
            value = entry.getValues();
        }
        return (T)value;
    }

    private void setEntryValue(FieldTagType fieldTagType, FieldType fieldType, long typeCount, Object values) {
        FileDirectoryEntry entry = new FileDirectoryEntry(fieldTagType, fieldType, typeCount, values);
        this.addEntry(entry);
    }

    private int sum(List<Integer> values, int start, int end) {
        int sum = 0;
        for (int i = start; i < end; ++i) {
            sum += values.get(i).intValue();
        }
        return sum;
    }

    private List<Integer> createSingleIntegerList(int value) {
        ArrayList<Integer> valueList = new ArrayList<Integer>();
        valueList.add(value);
        return valueList;
    }

    private List<Long> createSingleLongList(long value) {
        ArrayList<Long> valueList = new ArrayList<Long>();
        valueList.add(value);
        return valueList;
    }

    private List<Long> createRationalValue(long numerator) {
        List<Long> rational = this.createSingleLongList(numerator);
        rational.add(1L);
        return rational;
    }

    public long size() {
        return 2 + this.entries.size() * 12 + 4;
    }

    public long sizeWithValues() {
        long size = 6L;
        for (FileDirectoryEntry entry : this.entries) {
            size += entry.sizeWithValues();
        }
        return size;
    }
}

