/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.tiff;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mil.nga.tiff.FieldType;
import mil.nga.tiff.util.TiffException;

public class Rasters {
    private ByteBuffer[] sampleValues;
    private ByteBuffer interleaveValues;
    private final int width;
    private final int height;
    private final FieldType[] fieldTypes;
    private Integer pixelSize;
    private List<Integer> bitsPerSample;
    private List<Integer> sampleFormat;

    public Rasters(int width, int height, FieldType[] fieldTypes, ByteBuffer[] sampleValues) {
        this(width, height, fieldTypes, sampleValues, null);
    }

    public Rasters(int width, int height, FieldType[] fieldTypes, ByteBuffer interleaveValues) {
        this(width, height, fieldTypes, null, interleaveValues);
    }

    public Rasters(int width, int height, FieldType[] fieldTypes, ByteBuffer[] sampleValues, ByteBuffer interleaveValues) {
        this.width = width;
        this.height = height;
        this.fieldTypes = fieldTypes;
        this.sampleValues = sampleValues;
        this.interleaveValues = interleaveValues;
        this.validateValues();
    }

    public Rasters(int width, int height, int samplesPerPixel, FieldType fieldType) {
        this(width, height, Rasters.createFieldTypeArray(samplesPerPixel, fieldType));
    }

    public Rasters(int width, int height, int samplesPerPixel, FieldType fieldType, ByteOrder order) {
        this(width, height, Rasters.createFieldTypeArray(samplesPerPixel, fieldType), order);
    }

    public Rasters(int width, int height, int[] bitsPerSamples, int[] sampleFormats) {
        this(width, height, Rasters.createFieldTypeArray(bitsPerSamples, sampleFormats));
    }

    public Rasters(int width, int height, int[] bitsPerSamples, int[] sampleFormats, ByteOrder order) {
        this(width, height, Rasters.createFieldTypeArray(bitsPerSamples, sampleFormats), order);
    }

    public Rasters(int width, int height, int samplesPerPixel, int bitsPerSample, int sampleFormat) {
        this(width, height, samplesPerPixel, FieldType.getFieldType(sampleFormat, bitsPerSample));
    }

    public Rasters(int width, int height, int samplesPerPixel, int bitsPerSample, int sampleFormat, ByteOrder order) {
        this(width, height, samplesPerPixel, FieldType.getFieldType(sampleFormat, bitsPerSample), order);
    }

    public Rasters(int width, int height, FieldType[] fieldTypes) {
        this(width, height, fieldTypes, ByteOrder.nativeOrder());
    }

    public Rasters(int width, int height, FieldType[] fieldTypes, ByteOrder order) {
        this(width, height, fieldTypes, new ByteBuffer[fieldTypes.length]);
        for (int i = 0; i < this.sampleValues.length; ++i) {
            this.sampleValues[i] = ByteBuffer.allocateDirect(width * height * fieldTypes[i].getBytes()).order(order);
        }
    }

    private void validateValues() {
        if (this.sampleValues == null && this.interleaveValues == null) {
            throw new TiffException("Results must be sample and/or interleave based");
        }
    }

    private static FieldType[] createFieldTypeArray(int samplesPerPixel, FieldType fieldType) {
        FieldType[] result = new FieldType[samplesPerPixel];
        Arrays.fill((Object[])result, (Object)fieldType);
        return result;
    }

    private static FieldType[] createFieldTypeArray(int[] bitsPerSamples, int[] sampleFormats) {
        if (bitsPerSamples.length != sampleFormats.length) {
            throw new TiffException("Equal number of bits per samples and sample formats expected. Bits Per Samples: " + bitsPerSamples + ", Sample Formats: " + sampleFormats);
        }
        FieldType[] result = new FieldType[bitsPerSamples.length];
        for (int i = 0; i < bitsPerSamples.length; ++i) {
            result[i] = FieldType.getFieldType(sampleFormats[i], bitsPerSamples[i]);
        }
        return result;
    }

    public boolean hasSampleValues() {
        return this.sampleValues != null;
    }

    public boolean hasInterleaveValues() {
        return this.interleaveValues != null;
    }

    private void updateSampleInByteBuffer(ByteBuffer buffer, int bufferIndex, int sampleIndex, Number value) {
        if (bufferIndex < 0 || bufferIndex >= buffer.capacity()) {
            throw new IndexOutOfBoundsException("index: " + bufferIndex + ". Buffer capacity: " + buffer.capacity());
        }
        buffer.position(bufferIndex);
        this.writeSample(buffer, this.fieldTypes[sampleIndex], value);
    }

    private Number getSampleFromByteBuffer(ByteBuffer buffer, int index, int sampleIndex) {
        if (index < 0 || index >= buffer.capacity()) {
            throw new IndexOutOfBoundsException("Requested index: " + index + ", but size of buffer is: " + buffer.capacity());
        }
        buffer.position(index);
        return this.readSample(buffer, this.fieldTypes[sampleIndex]);
    }

    public void addToSample(int sampleIndex, int coordinate, Number value) {
        this.updateSampleInByteBuffer(this.sampleValues[sampleIndex], coordinate * this.fieldTypes[sampleIndex].getBytes(), sampleIndex, value);
    }

    public void addToInterleave(int sampleIndex, int coordinate, Number value) {
        int bufferPos = coordinate * this.sizePixel();
        for (int i = 0; i < sampleIndex; ++i) {
            bufferPos += this.fieldTypes[i].getBytes();
        }
        this.updateSampleInByteBuffer(this.interleaveValues, bufferPos, sampleIndex, value);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNumPixels() {
        return this.width * this.height;
    }

    public int getSamplesPerPixel() {
        return this.fieldTypes.length;
    }

    public List<Integer> getBitsPerSample() {
        List<Integer> result = this.bitsPerSample;
        if (result == null) {
            result = new ArrayList<Integer>(this.fieldTypes.length);
            for (FieldType fieldType : this.fieldTypes) {
                result.add(fieldType.getBits());
            }
            this.bitsPerSample = result;
        }
        return result;
    }

    public List<Integer> getSampleFormat() {
        List<Integer> result = this.sampleFormat;
        if (result == null) {
            result = new ArrayList<Integer>(this.fieldTypes.length);
            for (FieldType fieldType : this.fieldTypes) {
                result.add(FieldType.getSampleFormat(fieldType));
            }
            this.sampleFormat = result;
        }
        return result;
    }

    public ByteBuffer[] getSampleValues() {
        for (int i = 0; i < this.sampleValues.length; ++i) {
            this.sampleValues[i].rewind();
        }
        return this.sampleValues;
    }

    public void setSampleValues(ByteBuffer[] sampleValues) {
        this.sampleValues = sampleValues;
        this.sampleFormat = null;
        this.bitsPerSample = null;
        this.pixelSize = null;
        this.validateValues();
    }

    public ByteBuffer getInterleaveValues() {
        this.interleaveValues.rewind();
        return this.interleaveValues;
    }

    public void setInterleaveValues(ByteBuffer interleaveValues) {
        this.interleaveValues = interleaveValues;
        this.validateValues();
    }

    public Number[] getPixel(int x, int y) {
        this.validateCoordinates(x, y);
        Number[] pixel = new Number[this.getSamplesPerPixel()];
        if (this.sampleValues != null) {
            int sampleIndex = this.getSampleIndex(x, y);
            for (int i = 0; i < this.getSamplesPerPixel(); ++i) {
                int bufferIndex = sampleIndex * this.fieldTypes[i].getBytes();
                pixel[i] = this.getSampleFromByteBuffer(this.sampleValues[i], bufferIndex, i);
            }
        } else {
            int interleaveIndex = this.getInterleaveIndex(x, y);
            for (int i = 0; i < this.getSamplesPerPixel(); ++i) {
                pixel[i] = this.getSampleFromByteBuffer(this.interleaveValues, interleaveIndex, i);
                interleaveIndex += this.fieldTypes[i].getBytes();
            }
        }
        return pixel;
    }

    public void setPixel(int x, int y, Number[] values) {
        this.validateCoordinates(x, y);
        this.validateSample(values.length + 1);
        if (this.sampleValues != null) {
            for (int i = 0; i < this.getSamplesPerPixel(); ++i) {
                int bufferIndex = this.getSampleIndex(x, y) * this.fieldTypes[i].getBytes();
                this.updateSampleInByteBuffer(this.sampleValues[i], bufferIndex, i, values[i]);
            }
        } else {
            int interleaveIndex = this.getSampleIndex(x, y) * this.sizePixel();
            for (int i = 0; i < this.getSamplesPerPixel(); ++i) {
                this.updateSampleInByteBuffer(this.interleaveValues, interleaveIndex, i, values[i]);
                interleaveIndex += this.fieldTypes[i].getBytes();
            }
        }
    }

    public byte[] getPixelRow(int y, ByteOrder newOrder) {
        ByteBuffer outBuffer = ByteBuffer.allocate(this.getWidth() * this.sizePixel());
        outBuffer.order(newOrder);
        if (this.sampleValues != null) {
            int i;
            for (i = 0; i < this.getSamplesPerPixel(); ++i) {
                this.sampleValues[i].position(y * this.getWidth() * this.fieldTypes[i].getBytes());
            }
            for (i = 0; i < this.getWidth(); ++i) {
                for (int j = 0; j < this.getSamplesPerPixel(); ++j) {
                    this.writeSample(outBuffer, this.sampleValues[j], this.fieldTypes[j]);
                }
            }
        } else {
            this.interleaveValues.position(y * this.getWidth() * this.sizePixel());
            for (int i = 0; i < this.getWidth(); ++i) {
                for (int j = 0; j < this.getSamplesPerPixel(); ++j) {
                    this.writeSample(outBuffer, this.interleaveValues, this.fieldTypes[j]);
                }
            }
        }
        return outBuffer.array();
    }

    public byte[] getSampleRow(int y, int sample, ByteOrder newOrder) {
        ByteBuffer outBuffer = ByteBuffer.allocate(this.getWidth() * this.fieldTypes[sample].getBytes());
        outBuffer.order(newOrder);
        if (this.sampleValues != null) {
            this.sampleValues[sample].position(y * this.getWidth() * this.fieldTypes[sample].getBytes());
            for (int x = 0; x < this.getWidth(); ++x) {
                this.writeSample(outBuffer, this.sampleValues[sample], this.fieldTypes[sample]);
            }
        } else {
            int i;
            int sampleOffset = 0;
            for (i = 0; i < sample; ++i) {
                sampleOffset += this.fieldTypes[sample].getBytes();
            }
            for (i = 0; i < this.getWidth(); ++i) {
                this.interleaveValues.position((y * this.getWidth() + i) * this.sizePixel() + sampleOffset);
                this.writeSample(outBuffer, this.interleaveValues, this.fieldTypes[sample]);
            }
        }
        return outBuffer.array();
    }

    public Number getPixelSample(int sample, int x, int y) {
        this.validateCoordinates(x, y);
        this.validateSample(sample);
        Number pixelSample = null;
        if (this.sampleValues != null) {
            int bufferPos = this.getSampleIndex(x, y) * this.fieldTypes[sample].getBytes();
            pixelSample = this.getSampleFromByteBuffer(this.sampleValues[sample], bufferPos, sample);
        } else {
            int bufferPos = this.getInterleaveIndex(x, y);
            for (int i = 0; i < sample; ++i) {
                bufferPos += this.fieldTypes[sample].getBytes();
            }
            pixelSample = this.getSampleFromByteBuffer(this.interleaveValues, bufferPos, sample);
        }
        return pixelSample;
    }

    public void setPixelSample(int sample, int x, int y, Number value) {
        this.validateCoordinates(x, y);
        this.validateSample(sample);
        if (this.sampleValues != null) {
            int sampleIndex = this.getSampleIndex(x, y) * this.fieldTypes[sample].getBytes();
            this.updateSampleInByteBuffer(this.sampleValues[sample], sampleIndex, sample, value);
        }
        if (this.interleaveValues != null) {
            int interleaveIndex = this.getSampleIndex(x, y) * this.sizePixel();
            for (int i = 0; i < sample; ++i) {
                interleaveIndex += this.fieldTypes[sample].getBytes();
            }
            this.updateSampleInByteBuffer(this.interleaveValues, interleaveIndex, sample, value);
        }
    }

    public Number getFirstPixelSample(int x, int y) {
        return this.getPixelSample(0, x, y);
    }

    public void setFirstPixelSample(int x, int y, Number value) {
        this.setPixelSample(0, x, y, value);
    }

    public int getSampleIndex(int x, int y) {
        return y * this.width + x;
    }

    public int getInterleaveIndex(int x, int y) {
        return y * this.width * this.sizePixel() + x * this.sizePixel();
    }

    public int size() {
        return this.getNumPixels() * this.sizePixel();
    }

    public int sizePixel() {
        if (this.pixelSize != null) {
            return this.pixelSize;
        }
        int size = 0;
        for (int i = 0; i < this.getSamplesPerPixel(); ++i) {
            size += this.fieldTypes[i].getBytes();
        }
        this.pixelSize = size;
        return size;
    }

    private void validateCoordinates(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y > this.height) {
            throw new TiffException("Pixel oustide of raster range. Width: " + this.width + ", Height: " + this.height + ", x: " + x + ", y: " + y);
        }
    }

    private void validateSample(int sample) {
        if (sample < 0 || sample >= this.getSamplesPerPixel()) {
            throw new TiffException("Pixel sample out of bounds. sample: " + sample + ", samples per pixel: " + this.getSamplesPerPixel());
        }
    }

    public int calculateRowsPerStrip(int planarConfiguration) {
        return this.calculateRowsPerStrip(planarConfiguration, 8000);
    }

    public int calculateRowsPerStrip(int planarConfiguration, int maxBytesPerStrip) {
        Integer rowsPerStrip = null;
        if (planarConfiguration == 1) {
            rowsPerStrip = this.rowsPerStrip(this.sizePixel(), maxBytesPerStrip);
        } else {
            for (int sample = 0; sample < this.getSamplesPerPixel(); ++sample) {
                int rowsPerStripForSample = this.rowsPerStrip(this.fieldTypes[sample].getBytes(), maxBytesPerStrip);
                if (rowsPerStrip != null && rowsPerStripForSample >= rowsPerStrip) continue;
                rowsPerStrip = rowsPerStripForSample;
            }
        }
        return rowsPerStrip;
    }

    private int rowsPerStrip(int bytesPerPixel, int maxBytesPerStrip) {
        int bytesPerRow = bytesPerPixel * this.width;
        int rowsPerStrip = Math.max(1, maxBytesPerStrip / bytesPerRow);
        return rowsPerStrip;
    }

    private Number readSample(ByteBuffer buffer, FieldType fieldType) {
        Number sampleValue;
        switch (fieldType) {
            case BYTE: {
                sampleValue = (short)(buffer.get() & 0xFF);
                break;
            }
            case SHORT: {
                sampleValue = buffer.getShort() & 0xFFFF;
                break;
            }
            case LONG: {
                sampleValue = (long)buffer.getInt() & 0xFFFFFFFFL;
                break;
            }
            case SBYTE: {
                sampleValue = buffer.get();
                break;
            }
            case SSHORT: {
                sampleValue = buffer.getShort();
                break;
            }
            case SLONG: {
                sampleValue = buffer.getInt();
                break;
            }
            case FLOAT: {
                sampleValue = Float.valueOf(buffer.getFloat());
                break;
            }
            case DOUBLE: {
                sampleValue = buffer.getDouble();
                break;
            }
            default: {
                throw new TiffException("Unsupported raster field type: " + (Object)((Object)fieldType));
            }
        }
        return sampleValue;
    }

    private void writeSample(ByteBuffer buffer, FieldType fieldType, Number value) {
        switch (fieldType) {
            case BYTE: 
            case SBYTE: {
                buffer.put(value.byteValue());
                break;
            }
            case SHORT: 
            case SSHORT: {
                buffer.putShort(value.shortValue());
                break;
            }
            case LONG: 
            case SLONG: {
                buffer.putInt(value.intValue());
                break;
            }
            case FLOAT: {
                buffer.putFloat(value.floatValue());
                break;
            }
            case DOUBLE: {
                buffer.putDouble(value.doubleValue());
                break;
            }
            default: {
                throw new TiffException("Unsupported raster field type: " + (Object)((Object)fieldType));
            }
        }
    }

    private void writeSample(ByteBuffer outBuffer, ByteBuffer inBuffer, FieldType fieldType) {
        switch (fieldType) {
            case BYTE: 
            case SBYTE: {
                outBuffer.put(inBuffer.get());
                break;
            }
            case SHORT: 
            case SSHORT: {
                outBuffer.putShort(inBuffer.getShort());
                break;
            }
            case LONG: 
            case SLONG: {
                outBuffer.putInt(inBuffer.getInt());
                break;
            }
            case FLOAT: {
                outBuffer.putFloat(inBuffer.getFloat());
                break;
            }
            case DOUBLE: {
                outBuffer.putDouble(inBuffer.getDouble());
                break;
            }
            default: {
                throw new TiffException("Unsupported raster field type: " + (Object)((Object)fieldType));
            }
        }
    }

    public FieldType[] getFieldTypes() {
        return this.fieldTypes;
    }
}

