/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrpowers.spark.daria.sql;

import com.github.mrpowers.spark.daria.sql.MissingDataFrameColumnsException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Predef$;
import scala.StringContext;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001m3Q!\u0001\u0002\u0001\u00059\u0011q\u0003R1uC\u001a\u0013\u0018-\\3D_2,XN\\:DQ\u0016\u001c7.\u001a:\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0006I\u0006\u0014\u0018.\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\u00115\u0014\bo\\<feNT!a\u0003\u0007\u0002\r\u001dLG\u000f[;c\u0015\u0005i\u0011aA2p[N\u0011\u0001a\u0004\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011Y\u0001!\u0011!Q\u0001\na\t!\u0001\u001a4\u0004\u0001A\u0011\u0011$\f\b\u00035)r!a\u0007\u0015\u000f\u0005q1cBA\u000f$\u001d\tq\u0012%D\u0001 \u0015\t\u0001s#\u0001\u0004=e>|GOP\u0005\u0002E\u0005\u0019qN]4\n\u0005\u0011*\u0013AB1qC\u000eDWMC\u0001#\u0013\t9qE\u0003\u0002%K%\u00111!\u000b\u0006\u0003\u000f\u001dJ!a\u000b\u0017\u0002\u000fA\f7m[1hK*\u00111!K\u0005\u0003]=\u0012\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005-b\u0003\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002!I,\u0017/^5sK\u0012\u001cu\u000e\u001c(b[\u0016\u001c\bcA\u001a8u9\u0011AG\u000e\b\u0003=UJ\u0011AE\u0005\u0003WEI!\u0001O\u001d\u0003\u0007M+\u0017O\u0003\u0002,#A\u00111H\u0010\b\u0003!qJ!!P\t\u0002\rA\u0013X\rZ3g\u0013\ty\u0004I\u0001\u0004TiJLgn\u001a\u0006\u0003{EAQA\u0011\u0001\u0005\u0002\r\u000ba\u0001P5oSRtDc\u0001#G\u000fB\u0011Q\tA\u0007\u0002\u0005!)a#\u0011a\u00011!)\u0011'\u0011a\u0001e!9\u0011\n\u0001b\u0001\n\u0003Q\u0015AD7jgNLgnZ\"pYVlgn]\u000b\u0002\u0017B\u0019Aj\u0014\u001e\u000e\u00035S!AT\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u00029\u001b\"1\u0011\u000b\u0001Q\u0001\n-\u000bq\"\\5tg&twmQ8mk6t7\u000f\t\u0005\u0006'\u0002!\t\u0001V\u0001\u0016[&\u001c8/\u001b8h\u0007>dW/\u001c8t\u001b\u0016\u001c8/Y4f)\u0005Q\u0004\"\u0002,\u0001\t\u00039\u0016!\u0007<bY&$\u0017\r^3Qe\u0016\u001cXM\\2f\u001f\u001a\u001cu\u000e\\;n]N$\u0012\u0001\u0017\t\u0003!eK!AW\t\u0003\tUs\u0017\u000e\u001e")
public class DataFrameColumnsChecker {
    private final Dataset<Row> df;
    private final Seq<String> missingColumns;

    public Seq<String> missingColumns() {
        return this.missingColumns;
    }

    public String missingColumnsMessage() {
        String missingColNames = this.missingColumns().mkString(", ");
        String allColNames = Predef$.MODULE$.refArrayOps((Object[])this.df.columns()).mkString(", ");
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The [", "] columns are not included in the DataFrame with the following columns [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{missingColNames, allColNames}));
    }

    public void validatePresenceOfColumns() {
        if (this.missingColumns().nonEmpty()) {
            throw new MissingDataFrameColumnsException(this.missingColumnsMessage());
        }
    }

    public DataFrameColumnsChecker(Dataset<Row> df, Seq<String> requiredColNames) {
        this.df = df;
        this.missingColumns = (Seq)requiredColNames.diff((GenSeq)Predef$.MODULE$.refArrayOps((Object[])df.columns()).toSeq());
    }
}

