/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.decrypting.DecryptionStreamFactory;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.ByEMailKeySelectionStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.KeySelectionStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.Rfc4880KeySelectionStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.KeyringConfig;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.SignatureValidationStrategies;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.SignatureValidationStrategy;
import name.neuhalfen.projects.crypto.internal.Preconditions;
import org.bouncycastle.openpgp.PGPException;

public final class BuildDecryptionInputStreamAPI {
    @Nonnull
    private KeyringConfig keyringConfig;
    @Nonnull
    private SignatureValidationStrategy signatureCheckingMode;
    private ValidationWithKeySelectionStrategy keySelectionStrategyBuilder;
    private KeySelectionStrategy keySelectionStrategy;

    @Nonnull
    public ValidationWithKeySelectionStrategy withConfig(KeyringConfig keyringConfig) {
        Objects.requireNonNull(keyringConfig, "keyringConfig must not be null");
        this.keyringConfig = keyringConfig;
        return new ValidationWithKeySelectionStrategy();
    }

    private KeySelectionStrategy getKeySelectionStrategy() {
        if (this.keySelectionStrategy == null) {
            this.keySelectionStrategy = this.keySelectionStrategyBuilder.buildKeySelectionStrategy();
        }
        return this.keySelectionStrategy;
    }

    public final class ValidationWithKeySelectionStrategy
    extends ValidationImpl {
        private static final boolean SELECT_UID_BY_E_MAIL_ONLY_DEFAULT = true;
        @Nullable
        private Instant dateOfTimestampVerification;
        @Nullable
        private Boolean selectUidByEMailOnly;
        @Nullable
        private KeySelectionStrategy keySelectionStrategy;

        ValidationWithKeySelectionStrategy() {
            BuildDecryptionInputStreamAPI.this.keySelectionStrategyBuilder = this;
        }

        public Validation setReferenceDateForKeyValidityTo(Instant dateOfTimestampVerification) {
            Preconditions.checkState(this.keySelectionStrategy == null, "selectUidByAnyUidPart/setReferenceDateForKeyValidityTo cannot be used together with 'withKeySelectionStrategy' ");
            Objects.requireNonNull(dateOfTimestampVerification, "dateOfTimestampVerification must not be null");
            this.dateOfTimestampVerification = dateOfTimestampVerification;
            return this;
        }

        public Validation selectUidByAnyUidPart() {
            Preconditions.checkState(this.keySelectionStrategy == null, "selectUidByAnyUidPart/setReferenceDateForKeyValidityTo cannot be used together with 'withKeySelectionStrategy' ");
            this.selectUidByEMailOnly = false;
            return this;
        }

        public Validation withKeySelectionStrategy(KeySelectionStrategy strategy) {
            Objects.requireNonNull(strategy, "strategy must not be null");
            Preconditions.checkState(this.selectUidByEMailOnly == null && this.dateOfTimestampVerification == null, "selectUidByAnyUidPart/setReferenceDateForKeyValidityTo cannot be used together with 'withKeySelectionStrategy' ");
            this.keySelectionStrategy = strategy;
            return this;
        }

        private KeySelectionStrategy buildKeySelectionStrategy() {
            boolean hasExistingStrategy;
            boolean bl = hasExistingStrategy = this.keySelectionStrategy != null;
            if (hasExistingStrategy) {
                return this.keySelectionStrategy;
            }
            if (this.selectUidByEMailOnly == null) {
                this.selectUidByEMailOnly = true;
            }
            if (this.dateOfTimestampVerification == null) {
                this.dateOfTimestampVerification = Instant.now();
            }
            if (this.selectUidByEMailOnly.booleanValue()) {
                return new ByEMailKeySelectionStrategy(this.dateOfTimestampVerification);
            }
            return new Rfc4880KeySelectionStrategy(this.dateOfTimestampVerification);
        }
    }

    private class ValidationImpl
    implements Validation {
        private ValidationImpl() {
        }

        @Override
        @Nonnull
        public Build andRequireSignatureFromAllKeys(Long ... publicKeyIds) {
            Objects.requireNonNull(publicKeyIds, "publicKeyIds must not be null");
            Preconditions.checkArgument(publicKeyIds.length > 0, "publicKeyIds must not be empty");
            BuildDecryptionInputStreamAPI.this.signatureCheckingMode = SignatureValidationStrategies.requireSignatureFromAllKeys(publicKeyIds);
            return new Builder();
        }

        @Override
        @Nonnull
        public Build andRequireSignatureFromAllKeys(String ... userIds) throws PGPException, IOException {
            Objects.requireNonNull(userIds, "userIds must not be null");
            Preconditions.checkArgument(userIds.length > 0, "userIds must not be empty");
            BuildDecryptionInputStreamAPI.this.signatureCheckingMode = SignatureValidationStrategies.requireSignatureFromAllUids(BuildDecryptionInputStreamAPI.this.getKeySelectionStrategy(), BuildDecryptionInputStreamAPI.this.keyringConfig, userIds);
            return new Builder();
        }

        @Override
        @Nonnull
        public Build andValidateSomeoneSigned() {
            BuildDecryptionInputStreamAPI.this.signatureCheckingMode = SignatureValidationStrategies.requireAnySignature();
            return new Builder();
        }

        @Override
        @Nonnull
        public Build andIgnoreSignatures() {
            BuildDecryptionInputStreamAPI.this.signatureCheckingMode = SignatureValidationStrategies.ignoreSignatures();
            return new Builder();
        }

        public final class Builder
        implements Build {
            @Override
            @Nonnull
            public InputStream fromEncryptedInputStream(@Nullable InputStream encryptedData) throws IOException, NoSuchProviderException {
                Objects.requireNonNull(encryptedData, "encryptedData must not be null");
                DecryptionStreamFactory pgpInputStreamFactory = DecryptionStreamFactory.create(BuildDecryptionInputStreamAPI.this.keyringConfig, BuildDecryptionInputStreamAPI.this.signatureCheckingMode);
                return pgpInputStreamFactory.wrapWithDecryptAndVerify(encryptedData);
            }
        }
    }

    public static interface Validation {
        @Nonnull
        public Build andRequireSignatureFromAllKeys(Long ... var1);

        @Nonnull
        public Build andRequireSignatureFromAllKeys(String ... var1) throws PGPException, IOException;

        @Nonnull
        public Build andValidateSomeoneSigned();

        @Nonnull
        public Build andIgnoreSignatures();
    }

    public static interface Build {
        @Nonnull
        public InputStream fromEncryptedInputStream(InputStream var1) throws IOException, NoSuchProviderException;
    }
}

