/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp;

import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.time.Instant;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.algorithms.DefaultPGPAlgorithmSuites;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.algorithms.PGPAlgorithmSuite;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.encrypting.PGPEncryptingStream;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.ByEMailKeySelectionStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.KeySelectionStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.Rfc4880KeySelectionStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.KeyringConfig;
import name.neuhalfen.projects.crypto.internal.Preconditions;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BuildEncryptionOutputStreamAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildEncryptionOutputStreamAPI.class);
    private WithKeySelectionStrategy keySelectionStrategyBuilder;
    private KeySelectionStrategy keySelectionStrategy;
    private OutputStream sinkForEncryptedData;
    private KeyringConfig encryptionConfig;
    private PGPAlgorithmSuite algorithmSuite;
    @Nullable
    private String signWith;
    private Set<PGPPublicKey> recipients;
    private boolean armorOutput;

    public WithKeySelectionStrategy withConfig(KeyringConfig encryptionConfig) throws IOException, PGPException {
        Objects.requireNonNull(encryptionConfig, "encryptionConfig must not be null");
        Objects.requireNonNull(encryptionConfig.getKeyFingerPrintCalculator(), "encryptionConfig.getKeyFingerPrintCalculator() must not be null");
        Objects.requireNonNull(encryptionConfig.getPublicKeyRings(), "encryptionConfig.getPublicKeyRings() must not be null");
        this.encryptionConfig = encryptionConfig;
        return new WithKeySelectionStrategy();
    }

    private KeySelectionStrategy getKeySelectionStrategy() {
        if (this.keySelectionStrategy == null) {
            this.keySelectionStrategy = this.keySelectionStrategyBuilder.buildKeySelectionStrategy();
        }
        return this.keySelectionStrategy;
    }

    public final class WithKeySelectionStrategy
    extends WithAlgorithmSuiteImpl {
        private static final boolean SELECT_UID_BY_E_MAIL_ONLY_DEFAULT = true;
        @Nullable
        private Instant dateOfTimestampVerification;
        @Nullable
        private Boolean selectUidByEMailOnly;
        @Nullable
        private KeySelectionStrategy keySelectionStrategy;

        private WithKeySelectionStrategy() {
            BuildEncryptionOutputStreamAPI.this.keySelectionStrategyBuilder = this;
        }

        public WithKeySelectionStrategy selectUidByAnyUidPart() {
            Preconditions.checkState(this.keySelectionStrategy == null, "selectUidByAnyUidPart/setReferenceDateForKeyValidityTo cannot be used together with 'withKeySelectionStrategy' ");
            this.selectUidByEMailOnly = false;
            return this;
        }

        public WithAlgorithmSuite setReferenceDateForKeyValidityTo(Instant dateOfTimestampVerification) {
            Preconditions.checkState(this.keySelectionStrategy == null, "selectUidByAnyUidPart/setReferenceDateForKeyValidityTo cannot be used together with 'withKeySelectionStrategy' ");
            Objects.requireNonNull(dateOfTimestampVerification, "dateOfTimestampVerification must not be null");
            this.dateOfTimestampVerification = dateOfTimestampVerification;
            LOGGER.trace("WithKeySelectionStrategy: setReferenceDateForKeyValidityTo {}", (Object)dateOfTimestampVerification);
            return this;
        }

        public WithAlgorithmSuite withKeySelectionStrategy(KeySelectionStrategy strategy) {
            Objects.requireNonNull(strategy, "strategy must not be null");
            Preconditions.checkState(this.selectUidByEMailOnly == null && this.dateOfTimestampVerification == null, "selectUidByAnyUidPart/setReferenceDateForKeyValidityTo cannot be used together with 'withKeySelectionStrategy' ");
            this.keySelectionStrategy = strategy;
            LOGGER.trace("WithKeySelectionStrategy: override strategy to {}", (Object)strategy.getClass().toGenericString());
            return this;
        }

        private KeySelectionStrategy buildKeySelectionStrategy() {
            boolean hasExistingStrategy;
            boolean bl = hasExistingStrategy = this.keySelectionStrategy != null;
            if (hasExistingStrategy) {
                return this.keySelectionStrategy;
            }
            if (this.selectUidByEMailOnly == null) {
                this.selectUidByEMailOnly = true;
            }
            if (this.dateOfTimestampVerification == null) {
                this.dateOfTimestampVerification = Instant.now();
            }
            if (this.selectUidByEMailOnly.booleanValue()) {
                return new ByEMailKeySelectionStrategy(this.dateOfTimestampVerification);
            }
            return new Rfc4880KeySelectionStrategy(this.dateOfTimestampVerification);
        }
    }

    private class WithAlgorithmSuiteImpl
    implements WithAlgorithmSuite {
        private WithAlgorithmSuiteImpl() {
        }

        @Override
        public WithAlgorithmSuite.To withDefaultAlgorithms() {
            BuildEncryptionOutputStreamAPI.this.algorithmSuite = DefaultPGPAlgorithmSuites.defaultSuiteForGnuPG();
            LOGGER.trace("use algorithms {}", (Object)BuildEncryptionOutputStreamAPI.this.algorithmSuite.toString());
            return new ToImpl();
        }

        @Override
        public WithAlgorithmSuite.To withStrongAlgorithms() {
            BuildEncryptionOutputStreamAPI.this.algorithmSuite = DefaultPGPAlgorithmSuites.strongSuite();
            LOGGER.trace("use algorithms {}", (Object)BuildEncryptionOutputStreamAPI.this.algorithmSuite.toString());
            return new ToImpl();
        }

        @Override
        public WithAlgorithmSuite.To withOxAlgorithms() {
            BuildEncryptionOutputStreamAPI.this.algorithmSuite = DefaultPGPAlgorithmSuites.oxSuite();
            LOGGER.trace("use algorithms {}", (Object)BuildEncryptionOutputStreamAPI.this.toString());
            return new ToImpl();
        }

        @Override
        public WithAlgorithmSuite.To withAlgorithms(PGPAlgorithmSuite algorithmSuite) {
            Objects.requireNonNull(algorithmSuite, "algorithmSuite must not be null");
            BuildEncryptionOutputStreamAPI.this.algorithmSuite = algorithmSuite;
            LOGGER.trace("use algorithms {}", (Object)BuildEncryptionOutputStreamAPI.this.algorithmSuite.toString());
            return new ToImpl();
        }

        final class ToImpl
        implements WithAlgorithmSuite.To {
            ToImpl() {
            }

            private PGPPublicKey extractValidKey(String recipient) throws PGPException {
                Objects.requireNonNull(recipient, "recipient must not be null");
                Preconditions.checkArgument(!recipient.isEmpty(), "recipient must not be empty");
                try {
                    PGPPublicKey recipientEncryptionKey = BuildEncryptionOutputStreamAPI.this.getKeySelectionStrategy().selectPublicKey(KeySelectionStrategy.PURPOSE.FOR_ENCRYPTION, recipient, BuildEncryptionOutputStreamAPI.this.encryptionConfig);
                    if (recipientEncryptionKey == null) {
                        throw new PGPException("No (suitable) public key for encryption to " + recipient + " found");
                    }
                    LOGGER.trace("encrypt to recipient {} using key 0x{}", (Object)recipient, (Object)Long.toHexString(recipientEncryptionKey.getKeyID()));
                    return recipientEncryptionKey;
                }
                catch (IOException e) {
                    throw new PGPException("Failed to load keys", (Exception)e);
                }
            }

            @Override
            public WithAlgorithmSuite.To.SignWith toRecipient(String recipient) throws PGPException {
                BuildEncryptionOutputStreamAPI.this.recipients = new HashSet();
                BuildEncryptionOutputStreamAPI.this.recipients.add(this.extractValidKey(recipient));
                return new SignWithImpl();
            }

            @Override
            public WithAlgorithmSuite.To.SignWith toRecipients(String ... recipients) throws PGPException {
                BuildEncryptionOutputStreamAPI.this.recipients = new HashSet();
                for (String recipient : recipients) {
                    BuildEncryptionOutputStreamAPI.this.recipients.add(this.extractValidKey(recipient));
                }
                return new SignWithImpl();
            }

            final class SignWithImpl
            implements WithAlgorithmSuite.To.SignWith {
                SignWithImpl() {
                }

                @Override
                public WithAlgorithmSuite.To.SignWith.Armor andSignWith(String userId) throws IOException, PGPException {
                    Preconditions.checkState(BuildEncryptionOutputStreamAPI.this.encryptionConfig.getSecretKeyRings() != null, "encryptionConfig.getSecretKeyRings() must not be null");
                    PGPPublicKey signingKeyPubKey = BuildEncryptionOutputStreamAPI.this.getKeySelectionStrategy().selectPublicKey(KeySelectionStrategy.PURPOSE.FOR_SIGNING, userId, BuildEncryptionOutputStreamAPI.this.encryptionConfig);
                    if (signingKeyPubKey == null) {
                        throw new PGPException("No (suitable) public key for signing with '" + userId + "' found");
                    }
                    PGPSecretKey signingKey = BuildEncryptionOutputStreamAPI.this.encryptionConfig.getSecretKeyRings().getSecretKey(signingKeyPubKey.getKeyID());
                    if (signingKey == null) {
                        throw new PGPException("No (suitable) secret key for signing with " + userId + " found (public key exists!)");
                    }
                    BuildEncryptionOutputStreamAPI.this.signWith = userId;
                    LOGGER.trace("sign with {}", (Object)BuildEncryptionOutputStreamAPI.this.signWith);
                    return new ArmorImpl();
                }

                @Override
                public WithAlgorithmSuite.To.SignWith.Armor andDoNotSign() {
                    BuildEncryptionOutputStreamAPI.this.signWith = null;
                    LOGGER.trace("do not sign ");
                    return new ArmorImpl();
                }

                public final class ArmorImpl
                implements WithAlgorithmSuite.To.SignWith.Armor {
                    @Override
                    public Build binaryOutput() {
                        BuildEncryptionOutputStreamAPI.this.armorOutput = false;
                        LOGGER.trace("binary output");
                        return new Builder();
                    }

                    @Override
                    public Build armorAsciiOutput() {
                        BuildEncryptionOutputStreamAPI.this.armorOutput = true;
                        LOGGER.trace("ascii armor output");
                        return new Builder();
                    }

                    public final class Builder
                    implements Build {
                        @Override
                        public OutputStream andWriteTo(OutputStream sinkForEncryptedData) throws PGPException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
                            BuildEncryptionOutputStreamAPI.this.sinkForEncryptedData = sinkForEncryptedData;
                            return PGPEncryptingStream.create(BuildEncryptionOutputStreamAPI.this.encryptionConfig, BuildEncryptionOutputStreamAPI.this.algorithmSuite, BuildEncryptionOutputStreamAPI.this.signWith, BuildEncryptionOutputStreamAPI.this.sinkForEncryptedData, BuildEncryptionOutputStreamAPI.this.getKeySelectionStrategy(), BuildEncryptionOutputStreamAPI.this.armorOutput, BuildEncryptionOutputStreamAPI.this.recipients);
                        }
                    }
                }
            }
        }
    }

    public static interface WithAlgorithmSuite {
        public To withDefaultAlgorithms();

        public To withStrongAlgorithms();

        public To withOxAlgorithms();

        public To withAlgorithms(PGPAlgorithmSuite var1);

        public static interface To {
            public SignWith toRecipient(String var1) throws PGPException;

            public SignWith toRecipients(String ... var1) throws PGPException;

            public static interface SignWith {
                public Armor andSignWith(String var1) throws IOException, PGPException;

                public Armor andDoNotSign();

                public static interface Armor {
                    public Build binaryOutput();

                    public Build armorAsciiOutput();
                }
            }
        }
    }

    public static interface Build {
        public OutputStream andWriteTo(OutputStream var1) throws PGPException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException, IOException;
    }
}

