/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.algorithms;

import java.util.Objects;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.algorithms.PGPCompressionAlgorithms;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.algorithms.PGPHashAlgorithms;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.algorithms.PGPSymmetricEncryptionAlgorithms;

public final class PGPAlgorithmSuite {
    private final PGPHashAlgorithms hashAlgorithmCode;
    private final PGPSymmetricEncryptionAlgorithms symmetricEncryptionAlgorithmCode;
    private final PGPCompressionAlgorithms compressionEncryptionAlgorithmCode;

    public PGPAlgorithmSuite(PGPHashAlgorithms hashAlgorithmCode, PGPSymmetricEncryptionAlgorithms symmetricEncryptionAlgorithmCode, PGPCompressionAlgorithms compressionEncryptionAlgorithmCode) {
        Objects.requireNonNull(hashAlgorithmCode, "hashAlgorithmCode must not be null");
        Objects.requireNonNull(symmetricEncryptionAlgorithmCode, "symmetricEncryptionAlgorithmCode must not be null");
        Objects.requireNonNull(compressionEncryptionAlgorithmCode, "compressionEncryptionAlgorithmCode must not be null");
        this.hashAlgorithmCode = hashAlgorithmCode;
        this.symmetricEncryptionAlgorithmCode = symmetricEncryptionAlgorithmCode;
        this.compressionEncryptionAlgorithmCode = compressionEncryptionAlgorithmCode;
    }

    public PGPHashAlgorithms getHashAlgorithmCode() {
        return this.hashAlgorithmCode;
    }

    public PGPSymmetricEncryptionAlgorithms getSymmetricEncryptionAlgorithmCode() {
        return this.symmetricEncryptionAlgorithmCode;
    }

    @Deprecated
    public PGPCompressionAlgorithms getCompressionEncryptionAlgorithmCode() {
        return this.getCompressionAlgorithmCode();
    }

    public PGPCompressionAlgorithms getCompressionAlgorithmCode() {
        return this.compressionEncryptionAlgorithmCode;
    }

    public String toString() {
        return String.format("%s/%s/%s", new Object[]{this.hashAlgorithmCode, this.symmetricEncryptionAlgorithmCode, this.compressionEncryptionAlgorithmCode});
    }
}

