/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.algorithms;

import java.util.Set;
import name.neuhalfen.projects.crypto.internal.SetUtils;

public enum PGPCompressionAlgorithms {
    UNCOMPRESSED(0),
    ZIP(1),
    ZLIB(2),
    BZIP2(3);

    private static final Set<PGPCompressionAlgorithms> RECOMMENDED_ALGORITHMS;
    private static final int[] RECOMMENDED_ALGORITHM_IDS;
    private final int algorithmId;

    private PGPCompressionAlgorithms(int algorithmId) {
        this.algorithmId = algorithmId;
    }

    public static Set<PGPCompressionAlgorithms> recommendedAlgorithms() {
        return RECOMMENDED_ALGORITHMS;
    }

    public static int[] recommendedAlgorithmIds() {
        return (int[])RECOMMENDED_ALGORITHM_IDS.clone();
    }

    public int getAlgorithmId() {
        return this.algorithmId;
    }

    static {
        RECOMMENDED_ALGORITHMS = SetUtils.unmodifiableSet(BZIP2, ZLIB, ZIP, UNCOMPRESSED);
        RECOMMENDED_ALGORITHM_IDS = RECOMMENDED_ALGORITHMS.stream().mapToInt(algorithm -> algorithm.algorithmId).toArray();
    }
}

