/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.algorithms;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public enum PGPHashAlgorithms {
    MD5(1, true, true),
    SHA1(2, true, true),
    SHA_224(11, false, true),
    SHA_256(8, false, true),
    SHA_384(9, false, true),
    SHA_512(10, false, true),
    RIPEMD160(3, false, true),
    TIGER_192(6, false, false),
    HAVAL_5_160(7, true, true);

    private static final Set<PGPHashAlgorithms> RECOMMENDED_ALGORITHMS;
    private static final int[] RECOMMENDED_ALGORITHM_IDS;
    private final int algorithmId;
    private final boolean insecure;
    private final boolean supportedInGPG;

    private PGPHashAlgorithms(int algorithmId, boolean insecure, boolean supportedInGPG) {
        this.algorithmId = algorithmId;
        this.insecure = insecure;
        this.supportedInGPG = supportedInGPG;
    }

    public static Set<PGPHashAlgorithms> recommendedAlgorithms() {
        return RECOMMENDED_ALGORITHMS;
    }

    public static int[] recommendedAlgorithmIds() {
        return (int[])RECOMMENDED_ALGORITHM_IDS.clone();
    }

    public int getAlgorithmId() {
        return this.algorithmId;
    }

    public boolean isInsecure() {
        return this.insecure;
    }

    static {
        RECOMMENDED_ALGORITHMS = Collections.unmodifiableSet(Arrays.stream(PGPHashAlgorithms.values()).filter(alg -> !alg.insecure && alg.supportedInGPG).collect(Collectors.toSet()));
        RECOMMENDED_ALGORITHM_IDS = RECOMMENDED_ALGORITHMS.stream().mapToInt(algorithm -> algorithm.algorithmId).toArray();
    }
}

