/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.algorithms;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public enum PGPSymmetricEncryptionAlgorithms {
    NULL(0, true),
    IDEA(1, true),
    TRIPLE_DES(2, false),
    CAST5(3, true),
    BLOWFISH(4, true),
    SAFER(5, true),
    DES(6, true),
    AES_128(7, false),
    AES_192(8, false),
    AES_256(9, false),
    TWOFISH(10, false),
    CAMELLIA_128(11, false),
    CAMELLIA_192(12, false),
    CAMELLIA_256(13, false);

    private static final Set<PGPSymmetricEncryptionAlgorithms> RECOMMENDED_ALGORITHMS;
    private static final int[] RECOMMENDED_ALGORITHM_IDS;
    private final int algorithmId;
    private final boolean insecure;

    private PGPSymmetricEncryptionAlgorithms(int algorithmId, boolean insecure) {
        this.algorithmId = algorithmId;
        this.insecure = insecure;
    }

    public static Set<PGPSymmetricEncryptionAlgorithms> recommendedAlgorithms() {
        return RECOMMENDED_ALGORITHMS;
    }

    public static int[] recommendedAlgorithmIds() {
        return (int[])RECOMMENDED_ALGORITHM_IDS.clone();
    }

    public int getAlgorithmId() {
        return this.algorithmId;
    }

    public boolean isInsecure() {
        return this.insecure;
    }

    static {
        RECOMMENDED_ALGORITHMS = Collections.unmodifiableSet(Arrays.stream(PGPSymmetricEncryptionAlgorithms.values()).filter(alg -> !alg.insecure).collect(Collectors.toSet()));
        RECOMMENDED_ALGORITHM_IDS = RECOMMENDED_ALGORITHMS.stream().mapToInt(algorithm -> algorithm.algorithmId).toArray();
    }
}

