/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.algorithms;

import java.util.HashMap;
import java.util.Map;

public enum PublicKeyAlgorithm {
    RSA_GENERAL(1),
    RSA_ENCRYPT(2),
    RSA_SIGN(3),
    ELGAMAL_ENCRYPT(16),
    DSA(17),
    EC(18),
    ECDH(18),
    ECDSA(19),
    ELGAMAL_GENERAL(20),
    DIFFIE_HELLMAN(21);

    private static final Map<Integer, PublicKeyAlgorithm> MAP;
    private final int algorithmId;

    private PublicKeyAlgorithm(int algorithmId) {
        this.algorithmId = algorithmId;
    }

    public static PublicKeyAlgorithm fromId(int id) {
        return MAP.get(id);
    }

    public int getAlgorithmId() {
        return this.algorithmId;
    }

    static {
        MAP = new HashMap<Integer, PublicKeyAlgorithm>();
        for (PublicKeyAlgorithm p : PublicKeyAlgorithm.values()) {
            MAP.put(p.algorithmId, p);
        }
    }
}

