/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.decrypting;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MDCValidatingInputStream
extends FilterInputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(MDCValidatingInputStream.class);
    private final PGPPublicKeyEncryptedData pbe;

    MDCValidatingInputStream(InputStream inputStream, PGPPublicKeyEncryptedData pbe) {
        super(inputStream);
        this.pbe = pbe;
    }

    @Override
    public int read() throws IOException {
        boolean endOfStream;
        int data = super.read();
        boolean bl = endOfStream = data == -1;
        if (endOfStream) {
            this.validateMDC();
        }
        return data;
    }

    @Override
    public int read(@Nonnull byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(@Nonnull byte[] b, int off, int len) throws IOException {
        boolean endOfStream;
        int read = super.read(b, off, len);
        boolean bl = endOfStream = read == -1;
        if (endOfStream) {
            this.validateMDC();
        }
        return read;
    }

    private void validateMDC() throws IOException {
        try {
            if (this.pbe.isIntegrityProtected()) {
                if (!this.pbe.verify()) {
                    throw new PGPException("Data is integrity protected but integrity check failed");
                }
            } else {
                LOGGER.trace("Data integrity is not checked");
            }
        }
        catch (PGPException ex) {
            throw new IOException("Error while validating MDC", ex);
        }
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException("Skipping not supported");
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException("mark not supported");
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException("reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

