/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks;

import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.KeySelectionStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.KeyFlag;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.KeyringConfig;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rfc4880KeySelectionStrategy
implements KeySelectionStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(Rfc4880KeySelectionStrategy.class);
    private final Instant dateOfTimestampVerification;
    private final boolean ignoreCase;
    private final boolean matchPartial;
    private final List<Integer> encryptionAlgorithms = Arrays.asList(1, 2, 18, 16, 20);
    private final List<Integer> signatureAlgorithms = Arrays.asList(1, 3, 17, 19, 22);

    public Rfc4880KeySelectionStrategy(Instant dateOfTimestampVerification) {
        this(dateOfTimestampVerification, true, true);
    }

    public Rfc4880KeySelectionStrategy(Instant dateOfTimestampVerification, boolean matchPartial, boolean ignoreCase) {
        Objects.requireNonNull(dateOfTimestampVerification, "dateOfTimestampVerification must not be null");
        this.dateOfTimestampVerification = dateOfTimestampVerification;
        this.matchPartial = matchPartial;
        this.ignoreCase = ignoreCase;
    }

    protected Instant getDateOfTimestampVerification() {
        return this.dateOfTimestampVerification;
    }

    protected Set<PGPPublicKeyRing> publicKeyRingsForUid(KeySelectionStrategy.PURPOSE purpose, String uid, KeyringConfig keyringConfig) throws IOException, PGPException {
        HashSet<PGPPublicKeyRing> keyringsForUid = new HashSet<PGPPublicKeyRing>();
        Iterator keyRings = keyringConfig.getPublicKeyRings().getKeyRings(uid, this.matchPartial, this.ignoreCase);
        while (keyRings.hasNext()) {
            keyringsForUid.add((PGPPublicKeyRing)keyRings.next());
        }
        return keyringsForUid;
    }

    @Override
    public Set<PGPPublicKey> validPublicKeysForVerifyingSignatures(String uid, KeyringConfig keyringConfig) throws PGPException, IOException {
        Objects.requireNonNull(uid, "uid must not be null");
        Objects.requireNonNull(keyringConfig, "keyringConfig must not be null");
        Set<PGPPublicKeyRing> publicKeyrings = this.publicKeyRingsForUid(KeySelectionStrategy.PURPOSE.FOR_SIGNING, uid, keyringConfig);
        return publicKeyrings.stream().flatMap(keyring -> StreamSupport.stream(keyring.spliterator(), false)).filter(this::isVerificationKey).filter(this::isNotRevoked).filter(this::isNotExpired).collect(Collectors.toSet());
    }

    @Override
    @Nullable
    public PGPPublicKey selectPublicKey(KeySelectionStrategy.PURPOSE purpose, String uid, KeyringConfig keyringConfig) throws PGPException, IOException {
        Objects.requireNonNull(purpose, "purpose must not be null");
        Objects.requireNonNull(uid, "uid must not be null");
        Objects.requireNonNull(keyringConfig, "keyringConfig must not be null");
        Set<PGPPublicKeyRing> publicKeyrings = this.publicKeyRingsForUid(purpose, uid, keyringConfig);
        switch (purpose) {
            case FOR_SIGNING: {
                PGPSecretKeyRingCollection secretKeyRings = keyringConfig.getSecretKeyRings();
                return publicKeyrings.stream().flatMap(keyring -> StreamSupport.stream(keyring.spliterator(), false)).filter(this::isVerificationKey).filter(this::isNotRevoked).filter(this::isNotExpired).filter(this.hasPrivateKey(secretKeyRings)).reduce((a, b) -> b).orElse(null);
            }
            case FOR_ENCRYPTION: {
                return publicKeyrings.stream().flatMap(keyring -> StreamSupport.stream(keyring.spliterator(), false)).filter(this::isEncryptionKey).filter(this::isNotRevoked).filter(this::isNotExpired).reduce((a, b) -> b).orElse(null);
            }
        }
        return null;
    }

    protected Predicate<PGPPublicKey> hasPrivateKey(PGPSecretKeyRingCollection secretKeyRings) {
        return pubKey -> {
            Objects.requireNonNull(pubKey, "pubKey must not be null");
            try {
                boolean hasPrivateKey = secretKeyRings.contains(pubKey.getKeyID());
                if (!hasPrivateKey) {
                    LOGGER.trace("Skipping pubkey {} (no private key found)", (Object)Long.toHexString(pubKey.getKeyID()));
                }
                return hasPrivateKey;
            }
            catch (PGPException e) {
                LOGGER.debug("Failed to test for private key for pubkey " + pubKey.getKeyID());
                return false;
            }
        };
    }

    protected boolean isNotMasterKey(PGPPublicKey pubKey) {
        return !pubKey.isMasterKey();
    }

    protected boolean isNotExpired(PGPPublicKey pubKey) {
        return !this.isExpired(pubKey);
    }

    protected boolean isExpired(PGPPublicKey pubKey) {
        boolean isExpired;
        boolean hasExpiryDate;
        Objects.requireNonNull(pubKey, "pubKey must not be null");
        boolean bl = hasExpiryDate = pubKey.getValidSeconds() > 0L;
        if (hasExpiryDate) {
            Instant expiryDate = pubKey.getCreationTime().toInstant().plusSeconds(pubKey.getValidSeconds());
            isExpired = expiryDate.isBefore(this.getDateOfTimestampVerification());
            if (isExpired) {
                LOGGER.trace("Skipping pubkey {} (expired since {})", (Object)Long.toHexString(pubKey.getKeyID()), (Object)expiryDate.toString());
            }
        } else {
            isExpired = false;
        }
        return isExpired;
    }

    protected boolean isEncryptionKey(PGPPublicKey publicKey) {
        Objects.requireNonNull(publicKey, "publicKey must not be null");
        boolean isEncryptionKey = false;
        Optional<Set<KeyFlag>> optionalKeyFlags = KeyFlag.extractPublicKeyFlags(publicKey);
        if (optionalKeyFlags.isPresent()) {
            Set<KeyFlag> keyFlags = optionalKeyFlags.get();
            boolean canEncryptCommunication = keyFlags.contains((Object)KeyFlag.ENCRYPT_COMMS);
            boolean canEncryptStorage = keyFlags.contains((Object)KeyFlag.ENCRYPT_STORAGE);
            isEncryptionKey = canEncryptCommunication || canEncryptStorage;
        } else {
            isEncryptionKey = this.encryptionAlgorithms.contains(publicKey.getAlgorithm());
        }
        return isEncryptionKey;
    }

    protected boolean isVerificationKey(PGPPublicKey publicKey) {
        Objects.requireNonNull(publicKey, "publicKey must not be null");
        Optional<Set<KeyFlag>> optionalKeyFlags = KeyFlag.extractPublicKeyFlags(publicKey);
        boolean isVerificationKey = optionalKeyFlags.isPresent() ? optionalKeyFlags.get().contains((Object)KeyFlag.SIGN_DATA) : this.signatureAlgorithms.contains(publicKey.getAlgorithm());
        if (!isVerificationKey) {
            LOGGER.trace("Skipping pubkey {} (no signing key)", (Object)Long.toHexString(publicKey.getKeyID()));
        }
        return isVerificationKey;
    }

    protected boolean isRevoked(PGPPublicKey publicKey) {
        Objects.requireNonNull(publicKey, "pubKey must not be null");
        boolean hasRevocation = publicKey.hasRevocation();
        if (hasRevocation) {
            LOGGER.trace("Skipping pubkey {} (revoked)", (Object)Long.toHexString(publicKey.getKeyID()));
        }
        return hasRevocation;
    }

    protected boolean isNotRevoked(PGPPublicKey publicKey) {
        return !this.isRevoked(publicKey);
    }
}

