/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.KeyringConfigCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StaticPasswordFromMapKeyringConfigCallback
implements KeyringConfigCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticPasswordFromMapKeyringConfigCallback.class);
    private final Map<Long, char[]> keyIdToPassphrase;

    public StaticPasswordFromMapKeyringConfigCallback(Map<Long, char[]> mapSourceKeyIdToPassphrase) {
        Objects.requireNonNull(mapSourceKeyIdToPassphrase, "mapSourceKeyIdToPassphrase must not be null");
        this.keyIdToPassphrase = new HashMap<Long, char[]>(mapSourceKeyIdToPassphrase);
    }

    @Override
    public char[] decryptionSecretKeyPassphraseForSecretKeyId(long keyId) {
        char[] password = this.keyIdToPassphrase.get(keyId);
        if (password == null) {
            LOGGER.debug("No passphrase found for keyID 0x{}.", (Object)Long.toHexString(keyId));
        }
        return password;
    }
}

