/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation;

import java.util.Objects;
import javax.annotation.Nullable;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.KeySpecBuilderImpl;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.KeySpecBuilderInterface;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.type.KeyType;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;

public class KeySpec {
    private final KeyType keyType;
    private final PGPSignatureSubpacketGenerator subpacketGenerator;
    private final boolean inheritedSubPackets;

    KeySpec(KeyType type, @Nullable PGPSignatureSubpacketGenerator subpacketGenerator, boolean inheritedSubPackets) {
        this.keyType = type;
        this.subpacketGenerator = subpacketGenerator;
        this.inheritedSubPackets = inheritedSubPackets;
    }

    public static KeySpecBuilderInterface getBuilder(KeyType type) {
        Objects.requireNonNull(type, "type must not be null");
        return new KeySpecBuilderImpl(type);
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    @Nullable
    public PGPSignatureSubpacketVector getSubpackets() {
        return this.subpacketGenerator == null ? null : this.subpacketGenerator.generate();
    }

    public boolean isInheritedSubPackets() {
        return this.inheritedSubPackets;
    }
}

