/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation;

import java.util.Collection;
import java.util.Objects;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.algorithms.Feature;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.algorithms.PGPCompressionAlgorithms;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.algorithms.PGPHashAlgorithms;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.algorithms.PGPSymmetricEncryptionAlgorithms;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.KeyFlag;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.KeySpec;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.KeySpecBuilderInterface;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.type.KeyType;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;

class KeySpecBuilderImpl
implements KeySpecBuilderInterface {
    private final KeyType type;
    private final PGPSignatureSubpacketGenerator hashedSubPackets = new PGPSignatureSubpacketGenerator();

    KeySpecBuilderImpl(KeyType type) {
        this.type = Objects.requireNonNull(type);
    }

    @Override
    public KeySpecBuilderInterface.WithDetailedConfiguration allowKeyToBeUsedTo(KeyFlag ... flags) {
        int val = 0;
        for (KeyFlag f : flags) {
            val |= f.getFlag();
        }
        this.hashedSubPackets.setKeyFlags(false, val);
        return new WithDetailedConfigurationImpl();
    }

    @Override
    public KeySpecBuilderInterface.WithDetailedConfiguration allowKeyToBeUsedForEverything() {
        return this.allowKeyToBeUsedTo(KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA, KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE, KeyFlag.AUTHENTICATION);
    }

    @Override
    public KeySpec withInheritedSubPackets() {
        return new KeySpec(this.type, null, true);
    }

    private class WithDetailedConfigurationImpl
    implements KeySpecBuilderInterface.WithDetailedConfiguration {
        private WithDetailedConfigurationImpl() {
        }

        @Override
        @Deprecated
        public KeySpecBuilderInterface.WithPreferredSymmetricAlgorithms withDetailedConfiguration() {
            return new WithPreferredSymmetricAlgorithmsImpl();
        }

        @Override
        public KeySpec withDefaultAlgorithms() {
            KeySpecBuilderImpl.this.hashedSubPackets.setPreferredCompressionAlgorithms(false, PGPCompressionAlgorithms.recommendedAlgorithmIds());
            KeySpecBuilderImpl.this.hashedSubPackets.setPreferredSymmetricAlgorithms(false, PGPSymmetricEncryptionAlgorithms.recommendedAlgorithmIds());
            KeySpecBuilderImpl.this.hashedSubPackets.setPreferredHashAlgorithms(false, PGPHashAlgorithms.recommendedAlgorithmIds());
            KeySpecBuilderImpl.this.hashedSubPackets.setFeature(false, (byte)1);
            return new KeySpec(KeySpecBuilderImpl.this.type, KeySpecBuilderImpl.this.hashedSubPackets, false);
        }
    }

    private class WithFeaturesImpl
    implements KeySpecBuilderInterface.WithFeatures {
        private WithFeaturesImpl() {
        }

        @Override
        public KeySpecBuilderInterface.WithFeatures withFeature(Feature feature) {
            KeySpecBuilderImpl.this.hashedSubPackets.setFeature(false, feature.getFeatureId());
            return this;
        }

        @Override
        public KeySpec done() {
            return new KeySpec(KeySpecBuilderImpl.this.type, KeySpecBuilderImpl.this.hashedSubPackets, false);
        }
    }

    private class WithPreferredCompressionAlgorithmsImpl
    implements KeySpecBuilderInterface.WithPreferredCompressionAlgorithms {
        private WithPreferredCompressionAlgorithmsImpl() {
        }

        @Override
        public KeySpecBuilderInterface.WithFeatures withPreferredCompressionAlgorithms(PGPCompressionAlgorithms ... algorithms) {
            int[] ids = new int[algorithms.length];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = algorithms[i].getAlgorithmId();
            }
            KeySpecBuilderImpl.this.hashedSubPackets.setPreferredCompressionAlgorithms(false, ids);
            return new WithFeaturesImpl();
        }

        @Override
        public KeySpecBuilderInterface.WithFeatures withPreferredCompressionAlgorithms(Collection<PGPCompressionAlgorithms> algorithms) {
            int[] ids = new int[algorithms.size()];
            int i = 0;
            for (PGPCompressionAlgorithms algorithm : algorithms) {
                ids[i] = algorithm.getAlgorithmId();
                ++i;
            }
            KeySpecBuilderImpl.this.hashedSubPackets.setPreferredCompressionAlgorithms(false, ids);
            return new WithFeaturesImpl();
        }

        @Override
        public KeySpecBuilderInterface.WithFeatures withDefaultCompressionAlgorithms() {
            KeySpecBuilderImpl.this.hashedSubPackets.setPreferredCompressionAlgorithms(false, PGPCompressionAlgorithms.recommendedAlgorithmIds());
            return new WithFeaturesImpl();
        }
    }

    private class WithPreferredHashAlgorithmsImpl
    implements KeySpecBuilderInterface.WithPreferredHashAlgorithms {
        private WithPreferredHashAlgorithmsImpl() {
        }

        @Override
        public KeySpecBuilderInterface.WithPreferredCompressionAlgorithms withPreferredHashAlgorithms(PGPHashAlgorithms ... algorithms) {
            int[] ids = new int[algorithms.length];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = algorithms[i].getAlgorithmId();
            }
            KeySpecBuilderImpl.this.hashedSubPackets.setPreferredHashAlgorithms(false, ids);
            return new WithPreferredCompressionAlgorithmsImpl();
        }

        @Override
        public KeySpecBuilderInterface.WithPreferredCompressionAlgorithms withPreferredHashAlgorithms(Collection<PGPHashAlgorithms> algorithms) {
            int[] ids = new int[algorithms.size()];
            int i = 0;
            for (PGPHashAlgorithms algorithm : algorithms) {
                ids[i] = algorithm.getAlgorithmId();
                ++i;
            }
            KeySpecBuilderImpl.this.hashedSubPackets.setPreferredHashAlgorithms(false, ids);
            return new WithPreferredCompressionAlgorithmsImpl();
        }

        @Override
        public KeySpecBuilderInterface.WithPreferredCompressionAlgorithms withDefaultHashAlgorithms() {
            KeySpecBuilderImpl.this.hashedSubPackets.setPreferredHashAlgorithms(false, PGPHashAlgorithms.recommendedAlgorithmIds());
            return new WithPreferredCompressionAlgorithmsImpl();
        }
    }

    private class WithPreferredSymmetricAlgorithmsImpl
    implements KeySpecBuilderInterface.WithPreferredSymmetricAlgorithms {
        private WithPreferredSymmetricAlgorithmsImpl() {
        }

        @Override
        public KeySpecBuilderInterface.WithPreferredHashAlgorithms withPreferredSymmetricAlgorithms(PGPSymmetricEncryptionAlgorithms ... algorithms) {
            int[] ids = new int[algorithms.length];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = algorithms[i].getAlgorithmId();
            }
            KeySpecBuilderImpl.this.hashedSubPackets.setPreferredSymmetricAlgorithms(false, ids);
            return new WithPreferredHashAlgorithmsImpl();
        }

        @Override
        public KeySpecBuilderInterface.WithPreferredHashAlgorithms withPreferredSymmetricAlgorithms(Collection<PGPSymmetricEncryptionAlgorithms> algorithms) {
            int[] ids = new int[algorithms.size()];
            int i = 0;
            for (PGPSymmetricEncryptionAlgorithms algorithm : algorithms) {
                ids[i] = algorithm.getAlgorithmId();
                ++i;
            }
            KeySpecBuilderImpl.this.hashedSubPackets.setPreferredSymmetricAlgorithms(false, ids);
            return new WithPreferredHashAlgorithmsImpl();
        }

        @Override
        public KeySpecBuilderInterface.WithPreferredHashAlgorithms withDefaultSymmetricAlgorithms() {
            KeySpecBuilderImpl.this.hashedSubPackets.setPreferredSymmetricAlgorithms(false, PGPSymmetricEncryptionAlgorithms.recommendedAlgorithmIds());
            return new WithPreferredHashAlgorithmsImpl();
        }

        @Override
        public KeySpecBuilderInterface.WithFeatures withDefaultAlgorithms() {
            KeySpecBuilderImpl.this.hashedSubPackets.setPreferredSymmetricAlgorithms(false, PGPSymmetricEncryptionAlgorithms.recommendedAlgorithmIds());
            KeySpecBuilderImpl.this.hashedSubPackets.setPreferredCompressionAlgorithms(false, PGPCompressionAlgorithms.recommendedAlgorithmIds());
            KeySpecBuilderImpl.this.hashedSubPackets.setPreferredHashAlgorithms(false, PGPHashAlgorithms.recommendedAlgorithmIds());
            return new WithFeaturesImpl();
        }
    }
}

