/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

public class Passphrase {
    private final Object lock = new Object();
    @Nullable
    private final char[] chars;
    private final boolean empty;
    private boolean valid = true;

    public Passphrase(@Nullable char[] chars) {
        if (chars == null) {
            this.empty = true;
            this.chars = null;
        } else {
            this.chars = Arrays.copyOf(chars, chars.length);
            this.empty = chars.length <= 0;
        }
    }

    public static Passphrase emptyPassphrase() {
        return new Passphrase(null);
    }

    public static Passphrase fromString(String passphrase) {
        Objects.requireNonNull(passphrase);
        return new Passphrase(passphrase.toCharArray());
    }

    public static Passphrase fromChars(char[] passphrase) {
        Objects.requireNonNull(passphrase);
        return new Passphrase(passphrase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            if (this.chars != null) {
                Arrays.fill(this.chars, ' ');
            }
            this.valid = false;
        }
    }

    protected void finalize() throws Throwable {
        this.clear();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public char[] getChars() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.valid) {
                throw new IllegalStateException("Passphrase has been cleared.");
            }
            return this.chars == null ? null : Arrays.copyOf(this.chars, this.chars.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.empty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object object = this.lock;
        synchronized (object) {
            return this.valid;
        }
    }
}

