/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;

public final class KeyRingSubKeyFixUtil {
    private static final Logger LOGGER = Logger.getLogger(KeyRingSubKeyFixUtil.class.getName());

    private KeyRingSubKeyFixUtil() {
    }

    public static PGPSecretKeyRing repairSubkeyPackets(PGPSecretKeyRing secretKeys, @Nullable PBESecretKeyDecryptor decryptor, @Nullable PBESecretKeyEncryptor encryptor) throws PGPException {
        Objects.requireNonNull(secretKeys, "secretKeys cannot be null");
        PGPDigestCalculator calculator = new BcPGPDigestCalculatorProvider().get(2);
        ArrayList<PGPSecretKey> fixedSecretKeys = new ArrayList<PGPSecretKey>();
        Iterator secretKeyIterator = secretKeys.iterator();
        try {
            while (secretKeyIterator.hasNext()) {
                PGPSecretKey secSubKey = (PGPSecretKey)secretKeyIterator.next();
                if (secSubKey.isMasterKey()) {
                    fixedSecretKeys.add(secSubKey);
                    continue;
                }
                PGPPublicKey pubSubKey = secSubKey.getPublicKey();
                Field publicPk = pubSubKey.getClass().getDeclaredField("publicPk");
                publicPk.setAccessible(true);
                PublicKeyPacket keyPacket = (PublicKeyPacket)publicPk.get(pubSubKey);
                if (keyPacket instanceof PublicSubkeyPacket) {
                    fixedSecretKeys.add(secSubKey);
                    continue;
                }
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Subkey " + Long.toHexString(secSubKey.getKeyID()) + " does not have a subkey key packet. Converting it...");
                }
                keyPacket = new PublicSubkeyPacket(pubSubKey.getAlgorithm(), pubSubKey.getCreationTime(), keyPacket.getKey());
                publicPk.set(pubSubKey, keyPacket);
                PGPPrivateKey privateKey = secSubKey.extractPrivateKey(decryptor);
                PGPSecretKey secretKey = new PGPSecretKey(privateKey, pubSubKey, calculator, false, encryptor);
                fixedSecretKeys.add(secretKey);
            }
            return new PGPSecretKeyRing(fixedSecretKeys);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new UnsupportedOperationException("Cannot apply fix due to an error while using reflections.", e);
        }
    }

    public static Set<PGPSecretKey> violatingSubkeyPackets(PGPSecretKeyRing secretKeys) {
        Objects.requireNonNull(secretKeys, "secretKeys cannot be null");
        HashSet<PGPSecretKey> violatingPackets = new HashSet<PGPSecretKey>();
        Iterator secretKeyIterator = secretKeys.iterator();
        try {
            while (secretKeyIterator.hasNext()) {
                PGPPublicKey pubSubKey;
                PublicKeyPacket keyPacket;
                PGPSecretKey secSubKey = (PGPSecretKey)secretKeyIterator.next();
                if (secSubKey.isMasterKey() || (keyPacket = KeyRingSubKeyFixUtil.extractPublicKeyPacket(pubSubKey = secSubKey.getPublicKey())) instanceof PublicSubkeyPacket) continue;
                violatingPackets.add(secSubKey);
            }
            return violatingPackets;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new UnsupportedOperationException("Cannot apply fix due to an error while using reflections.", e);
        }
    }

    private static PublicKeyPacket extractPublicKeyPacket(PGPPublicKey pubSubKey) throws NoSuchFieldException, IllegalAccessException {
        Field publicPk = pubSubKey.getClass().getDeclaredField("publicPk");
        publicPk.setAccessible(true);
        return (PublicKeyPacket)publicPk.get(pubSubKey);
    }
}

