/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.type;

import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Objects;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.algorithms.PublicKeyAlgorithm;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.type.KeyType;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.type.length.RsaLength;

public class RSAKeyType
implements KeyType {
    private final RsaLength length;

    RSAKeyType(RsaLength length) {
        Objects.requireNonNull(length, "length cannot be null");
        this.length = length;
    }

    public static RSAKeyType withLength(RsaLength length) {
        Objects.requireNonNull(length, "length cannot be null");
        return new RSAKeyType(length);
    }

    @Override
    public String getName() {
        return "RSA";
    }

    @Override
    public PublicKeyAlgorithm getAlgorithm() {
        return PublicKeyAlgorithm.RSA_GENERAL;
    }

    @Override
    public AlgorithmParameterSpec getAlgorithmSpec() {
        return new RSAKeyGenParameterSpec(this.length.getLength(), RSAKeyGenParameterSpec.F4);
    }
}

