/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation;

import java.io.IOException;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.SignatureValidationHelper;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.SignatureValidationStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.SignaturesMissingException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RequireSpecificSignatureValidationForUserIdsStrategy
implements SignatureValidationStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequireSpecificSignatureValidationForUserIdsStrategy.class);
    private final Map<String, Set<Long>> keysByUid;

    RequireSpecificSignatureValidationForUserIdsStrategy(Map<String, Set<Long>> keysByUid) {
        Objects.requireNonNull(keysByUid, "keysByUid must not be null");
        this.keysByUid = new HashMap<String, Set<Long>>(keysByUid);
    }

    @Nullable
    private String uidForKeyId(long keyId) {
        for (String uid : this.keysByUid.keySet()) {
            Set<Long> keyIds = this.keysByUid.get(uid);
            if (!keyIds.contains(keyId)) continue;
            return uid;
        }
        return null;
    }

    @Override
    public void validateSignatures(PGPObjectFactory factory, Map<Long, PGPOnePassSignature> onePassSignatures) throws SignatureException, PGPException, IOException {
        Objects.requireNonNull(factory, "factory must not be null");
        Objects.requireNonNull(onePassSignatures, "onePassSignatures must not be null");
        PGPSignatureList signatureList = this.extractPgpSignatures(factory);
        HashSet<String> signaturesRequired = new HashSet<String>(this.keysByUid.keySet());
        Set<Long> knownKeysWithGoodSignatures = SignatureValidationHelper.knownKeysWithGoodSignatures(onePassSignatures, signatureList);
        knownKeysWithGoodSignatures.forEach(keyId -> signaturesRequired.remove(this.uidForKeyId((long)keyId)));
        boolean successfullyVerified = signaturesRequired.isEmpty();
        if (!successfullyVerified) {
            throw this.createMissingSignaturesException(signaturesRequired);
        }
        LOGGER.debug("Signature verification success");
    }

    private PGPSignatureList extractPgpSignatures(PGPObjectFactory factory) throws IOException, SignaturesMissingException {
        PGPSignatureList signatureList = (PGPSignatureList)factory.nextObject();
        if (signatureList == null || signatureList.isEmpty()) {
            throw this.createMissingSignaturesException(this.keysByUid.keySet());
        }
        return signatureList;
    }

    private SignaturesMissingException createMissingSignaturesException(Set<String> missingUids) {
        return new SignaturesMissingException("Signature verification failed because all of the following signatures (by userId) are missing.", SignaturesMissingException.MissingSignature.fromUids(missingUids), SignaturesMissingException.SetSemantics.ALL_SIGNATURES_MISSING);
    }

    @Override
    public boolean isRequireSignatureCheck() {
        return true;
    }
}

