/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation;

import java.io.IOException;
import java.security.SignatureException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.SignatureValidationHelper;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.SignatureValidationStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.SignaturesMissingException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RequireSpecificSignatureValidationStrategy
implements SignatureValidationStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequireSpecificSignatureValidationStrategy.class);
    private final Set<Long> signaturesRequiredForTheseKeys;

    RequireSpecificSignatureValidationStrategy(Collection<Long> signaturesRequiredForTheseKeys) {
        Objects.requireNonNull(signaturesRequiredForTheseKeys, "signaturesRequiredForTheseKeys must not be null");
        this.signaturesRequiredForTheseKeys = new HashSet<Long>(signaturesRequiredForTheseKeys);
    }

    @Override
    public void validateSignatures(PGPObjectFactory factory, Map<Long, PGPOnePassSignature> onePassSignatures) throws SignatureException, PGPException, IOException {
        Objects.requireNonNull(factory, "factory must not be null");
        Objects.requireNonNull(onePassSignatures, "onePassSignatures must not be null");
        PGPSignatureList signatureList = this.extractPgpSignatures(factory);
        Set<Long> keysWithGoodSignatures = SignatureValidationHelper.knownKeysWithGoodSignatures(onePassSignatures, signatureList);
        HashSet<Long> signaturesRequiredForTheseKeysCheckList = new HashSet<Long>(this.signaturesRequiredForTheseKeys);
        signaturesRequiredForTheseKeysCheckList.removeAll(keysWithGoodSignatures);
        boolean successfullyVerified = signaturesRequiredForTheseKeysCheckList.isEmpty();
        if (!successfullyVerified) {
            throw this.createMissingSignaturesException(signaturesRequiredForTheseKeysCheckList);
        }
        LOGGER.debug("Signature verification success");
    }

    private PGPSignatureList extractPgpSignatures(PGPObjectFactory factory) throws IOException, SignaturesMissingException {
        PGPSignatureList signatureList = (PGPSignatureList)factory.nextObject();
        if (signatureList == null || signatureList.isEmpty()) {
            throw this.createMissingSignaturesException(this.signaturesRequiredForTheseKeys);
        }
        return signatureList;
    }

    private SignaturesMissingException createMissingSignaturesException(Set<Long> missingForKeyIds) {
        return new SignaturesMissingException("Signature verification failed because all of the following signatures (by keyId) are missing.", SignaturesMissingException.MissingSignature.fromKeyIds(missingForKeyIds), SignaturesMissingException.SetSemantics.ALL_SIGNATURES_MISSING);
    }

    @Override
    public boolean isRequireSignatureCheck() {
        return true;
    }
}

