/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SignatureValidationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignatureValidationHelper.class);

    private SignatureValidationHelper() {
    }

    public static Set<Long> knownKeysWithGoodSignatures(Map<Long, PGPOnePassSignature> onePassSignatures, PGPSignatureList signatureList) throws PGPException {
        HashSet<Long> goodSignatures = new HashSet<Long>();
        for (PGPSignature messageSignature : signatureList) {
            boolean isHasPubKeyForSignature;
            PGPOnePassSignature ops = onePassSignatures.get(messageSignature.getKeyID());
            boolean bl = isHasPubKeyForSignature = ops != null;
            if (isHasPubKeyForSignature) {
                boolean isThisSignatureGood = ops.verify(messageSignature);
                if (!isThisSignatureGood) continue;
                LOGGER.debug("Successful validated signature with key 0x{}", (Object)Long.toHexString(messageSignature.getKeyID()));
                goodSignatures.add(messageSignature.getKeyID());
                continue;
            }
            LOGGER.debug("Could not validated signature with key 0x{} because we have no matching public key", (Object)Long.toHexString(messageSignature.getKeyID()));
        }
        return goodSignatures;
    }
}

