/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.KeySelectionStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.KeyringConfig;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.IgnoreSignaturesValidationStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.RequireAnySignatureValidationStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.RequireSpecificSignatureValidationForUserIdsStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.RequireSpecificSignatureValidationStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.SignatureValidationStrategy;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;

public final class SignatureValidationStrategies {
    private SignatureValidationStrategies() {
    }

    public static SignatureValidationStrategy ignoreSignatures() {
        return new IgnoreSignaturesValidationStrategy();
    }

    public static SignatureValidationStrategy requireAnySignature() {
        return new RequireAnySignatureValidationStrategy();
    }

    public static SignatureValidationStrategy requireSignatureFromAllUids(KeySelectionStrategy keySelectionStrategy, KeyringConfig config, String ... userIds) throws PGPException {
        Objects.requireNonNull(keySelectionStrategy, "keySelectionStrategy must not be null");
        Objects.requireNonNull(config, "config must not be null");
        Objects.requireNonNull(userIds, "userIds must not be null");
        HashMap<String, Set<Long>> keyIdsByUid = new HashMap<String, Set<Long>>();
        for (String userId : userIds) {
            Set<PGPPublicKey> availableKeys = SignatureValidationStrategies.validPublicKeysForVerifyingSignatures(keySelectionStrategy, config, userId);
            if (availableKeys.isEmpty()) {
                throw new PGPException("Could not find public-key for userid '" + userId + "'");
            }
            Set keysForUid = availableKeys.stream().map(PGPPublicKey::getKeyID).collect(Collectors.toSet());
            keyIdsByUid.put(userId, keysForUid);
        }
        return new RequireSpecificSignatureValidationForUserIdsStrategy(keyIdsByUid);
    }

    @Deprecated
    public static SignatureValidationStrategy requireSignatureFromAllKeys(KeySelectionStrategy keySelectionStrategy, KeyringConfig config, String ... userIds) throws PGPException {
        Objects.requireNonNull(keySelectionStrategy, "keySelectionStrategy must not be null");
        Objects.requireNonNull(config, "config must not be null");
        Objects.requireNonNull(userIds, "userIds must not be null");
        ArrayList<Long> keyIds = new ArrayList<Long>(userIds.length);
        for (String userId : userIds) {
            Set<PGPPublicKey> availableKeys = SignatureValidationStrategies.validPublicKeysForVerifyingSignatures(keySelectionStrategy, config, userId);
            if (availableKeys.isEmpty()) {
                throw new PGPException("Could not find public-key for userid '" + userId + "'");
            }
            if (availableKeys.size() > 1) {
                throw new PGPException("Found more than one (" + availableKeys.size() + ") keys for userid '" + userId + "'");
            }
            PGPPublicKey selectPublicKey = availableKeys.iterator().next();
            keyIds.add(selectPublicKey.getKeyID());
        }
        return new RequireSpecificSignatureValidationStrategy(keyIds);
    }

    private static Set<PGPPublicKey> validPublicKeysForVerifyingSignatures(KeySelectionStrategy keySelectionStrategy, KeyringConfig config, String userId) throws PGPException {
        try {
            return keySelectionStrategy.validPublicKeysForVerifyingSignatures(userId, config);
        }
        catch (IOException e) {
            throw new PGPException("Failed to extract keys", (Exception)e);
        }
    }

    public static SignatureValidationStrategy requireSignatureFromAllKeys(Collection<Long> signaturesRequiredForTheseKeys) {
        return new RequireSpecificSignatureValidationStrategy(signaturesRequiredForTheseKeys);
    }

    public static SignatureValidationStrategy requireSignatureFromAllKeys(Long ... keyIds) {
        Objects.requireNonNull(keyIds, "keyIds must not be null");
        return new RequireSpecificSignatureValidationStrategy(Arrays.asList(keyIds));
    }

    public static SignatureValidationStrategy requireSignatureFromAllKeys(long signaturesRequiredForThisKey) {
        return new RequireSpecificSignatureValidationStrategy(Collections.singletonList(signaturesRequiredForThisKey));
    }
}

