/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation;

import java.security.SignatureException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SignaturesMissingException
extends SignatureException {
    private static final long serialVersionUID = -7306258581793628971L;
    private final Set<MissingSignature> missingSignatures;
    private final SetSemantics missingSignaturesSemantics;

    public SignaturesMissingException(String message) {
        super(message);
        this.missingSignaturesSemantics = SetSemantics.ALL_SIGNATURES_MISSING;
        this.missingSignatures = Collections.EMPTY_SET;
    }

    public SignaturesMissingException(String message, Set<MissingSignature> missingSignatures, SetSemantics missingSignaturesSemantics) {
        super(message);
        this.missingSignatures = Collections.unmodifiableSet(new HashSet<MissingSignature>(missingSignatures));
        this.missingSignaturesSemantics = missingSignaturesSemantics;
    }

    public Set<MissingSignature> getMissingSignatures() {
        return this.missingSignatures;
    }

    public SetSemantics getMissingSignaturesSemantics() {
        return this.missingSignaturesSemantics;
    }

    public static enum SetSemantics {
        ANY_SIGNATURE_MISSING,
        ALL_SIGNATURES_MISSING;

    }

    public static final class MissingSignature {
        @Nullable
        private final String uid;
        @Nullable
        private final Long keyId;

        public MissingSignature(@Nullable String uid, @Nullable Long keyId) {
            this.uid = uid;
            this.keyId = keyId;
        }

        public static MissingSignature fromKeyId(Long keyId) {
            Objects.requireNonNull(keyId, "keyId must not be null");
            return new MissingSignature(null, keyId);
        }

        public static Set<MissingSignature> fromKeyIds(Set<Long> keyIds) {
            Objects.requireNonNull(keyIds, "keyIds must not be null");
            return keyIds.stream().map(MissingSignature::fromKeyId).collect(Collectors.toSet());
        }

        public static MissingSignature fromUid(String uid) {
            Objects.requireNonNull(uid, "uid must not be null");
            return new MissingSignature(uid, null);
        }

        public static Set<MissingSignature> fromUids(Set<String> uids) {
            Objects.requireNonNull(uids, "uids must not be null");
            return uids.stream().map(MissingSignature::fromUid).collect(Collectors.toSet());
        }

        @Nullable
        public String getUid() {
            return this.uid;
        }

        @Nullable
        public Long getKeyId() {
            return this.keyId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            MissingSignature that = (MissingSignature)other;
            return Objects.equals(this.getUid(), that.getUid()) && Objects.equals(this.getKeyId(), that.getKeyId());
        }

        public int hashCode() {
            return Objects.hash(this.getUid(), this.getKeyId());
        }

        public String toString() {
            return "MissingSignature{" + "uid='" + (this.uid == null ? "???" : this.uid) + '\'' + ", keyId=0x" + (this.keyId == null ? "???" : Long.toHexString(this.keyId)) + '}';
        }
    }
}

