package name.remal.gradle_plugins.dsl.extensions
import org.gradle.api.Task
import org.gradle.util.GradleVersion
private val IS_GRADLE_4_7_OR_ABOVE = GradleVersion.current() >= GradleVersion.version("4.7")


/**
 * @see org.gradle.api.logging.Logger.isLifecycleEnabled
 */
val Task.isLifecycleLogEnabled get() = logger.isLifecycleEnabled

/**
 * @see org.gradle.api.logging.Logger.lifecycle
 */
fun Task.logLifecycle(message: String) {
    if (logger.isLifecycleEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.lifecycle(message)
        } else {
            logger.lifecycle("$path: $message")
        }
    }
}

/**
 * @see org.gradle.api.logging.Logger.lifecycle
 */
fun Task.logLifecycle(message: String, vararg objects: Any?) {
    if (logger.isLifecycleEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.lifecycle(message, *objects)
        } else {
            logger.lifecycle("$path: $message", *objects)
        }
    }
}

/**
 * @see org.gradle.api.logging.Logger.lifecycle
 */
fun Task.logLifecycle(message: String, throwable: Throwable?) {
    if (logger.isLifecycleEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.lifecycle(message, throwable)
        } else {
            logger.lifecycle("$path: $message", throwable)
        }
    }
}

/**
 * @see org.gradle.api.logging.Logger.lifecycle
 */
fun Task.logLifecycle(throwable: Throwable) {
    if (logger.isLifecycleEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.lifecycle(throwable.toString(), throwable)
        } else {
            logger.lifecycle("$path: $throwable", throwable)
        }
    }
}


/**
 * @see org.gradle.api.logging.Logger.isQuietEnabled
 */
val Task.isQuietLogEnabled get() = logger.isQuietEnabled

/**
 * @see org.gradle.api.logging.Logger.quiet
 */
fun Task.logQuiet(message: String) {
    if (logger.isQuietEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.quiet(message)
        } else {
            logger.quiet("$path: $message")
        }
    }
}

/**
 * @see org.gradle.api.logging.Logger.quiet
 */
fun Task.logQuiet(message: String, vararg objects: Any?) {
    if (logger.isQuietEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.quiet(message, *objects)
        } else {
            logger.quiet("$path: $message", *objects)
        }
    }
}

/**
 * @see org.gradle.api.logging.Logger.quiet
 */
fun Task.logQuiet(message: String, throwable: Throwable?) {
    if (logger.isQuietEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.quiet(message, throwable)
        } else {
            logger.quiet("$path: $message", throwable)
        }
    }
}

/**
 * @see org.gradle.api.logging.Logger.quiet
 */
fun Task.logQuiet(throwable: Throwable) {
    if (logger.isQuietEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.quiet(throwable.toString(), throwable)
        } else {
            logger.quiet("$path: $throwable", throwable)
        }
    }
}


/**
 * @see org.gradle.api.logging.Logger.isInfoEnabled
 */
val Task.isInfoLogEnabled get() = logger.isInfoEnabled

/**
 * @see org.gradle.api.logging.Logger.info
 */
fun Task.logInfo(message: String) {
    if (logger.isInfoEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.info(message)
        } else {
            logger.info("$path: $message")
        }
    }
}

/**
 * @see org.gradle.api.logging.Logger.info
 */
fun Task.logInfo(message: String, vararg objects: Any?) {
    if (logger.isInfoEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.info(message, *objects)
        } else {
            logger.info("$path: $message", *objects)
        }
    }
}

/**
 * @see org.gradle.api.logging.Logger.info
 */
fun Task.logInfo(message: String, throwable: Throwable?) {
    if (logger.isInfoEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.info(message, throwable)
        } else {
            logger.info("$path: $message", throwable)
        }
    }
}

/**
 * @see org.gradle.api.logging.Logger.info
 */
fun Task.logInfo(throwable: Throwable) {
    if (logger.isInfoEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.info(throwable.toString(), throwable)
        } else {
            logger.info("$path: $throwable", throwable)
        }
    }
}


/**
 * @see org.gradle.api.logging.Logger.isWarnEnabled
 */
val Task.isWarnLogEnabled get() = logger.isWarnEnabled

/**
 * @see org.gradle.api.logging.Logger.warn
 */
fun Task.logWarn(message: String) {
    if (logger.isWarnEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.warn(message)
        } else {
            logger.warn("$path: $message")
        }
    }
}

/**
 * @see org.gradle.api.logging.Logger.warn
 */
fun Task.logWarn(message: String, vararg objects: Any?) {
    if (logger.isWarnEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.warn(message, *objects)
        } else {
            logger.warn("$path: $message", *objects)
        }
    }
}

/**
 * @see org.gradle.api.logging.Logger.warn
 */
fun Task.logWarn(message: String, throwable: Throwable?) {
    if (logger.isWarnEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.warn(message, throwable)
        } else {
            logger.warn("$path: $message", throwable)
        }
    }
}

/**
 * @see org.gradle.api.logging.Logger.warn
 */
fun Task.logWarn(throwable: Throwable) {
    if (logger.isWarnEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.warn(throwable.toString(), throwable)
        } else {
            logger.warn("$path: $throwable", throwable)
        }
    }
}


/**
 * @see org.gradle.api.logging.Logger.isErrorEnabled
 */
val Task.isErrorLogEnabled get() = logger.isErrorEnabled

/**
 * @see org.gradle.api.logging.Logger.error
 */
fun Task.logError(message: String) {
    if (logger.isErrorEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.error(message)
        } else {
            logger.error("$path: $message")
        }
    }
}

/**
 * @see org.gradle.api.logging.Logger.error
 */
fun Task.logError(message: String, vararg objects: Any?) {
    if (logger.isErrorEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.error(message, *objects)
        } else {
            logger.error("$path: $message", *objects)
        }
    }
}

/**
 * @see org.gradle.api.logging.Logger.error
 */
fun Task.logError(message: String, throwable: Throwable?) {
    if (logger.isErrorEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.error(message, throwable)
        } else {
            logger.error("$path: $message", throwable)
        }
    }
}

/**
 * @see org.gradle.api.logging.Logger.error
 */
fun Task.logError(throwable: Throwable) {
    if (logger.isErrorEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.error(throwable.toString(), throwable)
        } else {
            logger.error("$path: $throwable", throwable)
        }
    }
}


/**
 * @see org.gradle.api.logging.Logger.isDebugEnabled
 */
val Task.isDebugLogEnabled get() = logger.isDebugEnabled

/**
 * @see org.gradle.api.logging.Logger.debug
 */
fun Task.logDebug(message: String) {
    if (logger.isDebugEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.debug(message)
        } else {
            logger.debug("$path: $message")
        }
    }
}

/**
 * @see org.gradle.api.logging.Logger.debug
 */
fun Task.logDebug(message: String, vararg objects: Any?) {
    if (logger.isDebugEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.debug(message, *objects)
        } else {
            logger.debug("$path: $message", *objects)
        }
    }
}

/**
 * @see org.gradle.api.logging.Logger.debug
 */
fun Task.logDebug(message: String, throwable: Throwable?) {
    if (logger.isDebugEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.debug(message, throwable)
        } else {
            logger.debug("$path: $message", throwable)
        }
    }
}

/**
 * @see org.gradle.api.logging.Logger.debug
 */
fun Task.logDebug(throwable: Throwable) {
    if (logger.isDebugEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.debug(throwable.toString(), throwable)
        } else {
            logger.debug("$path: $throwable", throwable)
        }
    }
}


/**
 * @see org.gradle.api.logging.Logger.isTraceEnabled
 */
val Task.isTraceLogEnabled get() = logger.isTraceEnabled

/**
 * @see org.gradle.api.logging.Logger.trace
 */
fun Task.logTrace(message: String) {
    if (logger.isTraceEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.trace(message)
        } else {
            logger.trace("$path: $message")
        }
    }
}

/**
 * @see org.gradle.api.logging.Logger.trace
 */
fun Task.logTrace(message: String, vararg objects: Any?) {
    if (logger.isTraceEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.trace(message, *objects)
        } else {
            logger.trace("$path: $message", *objects)
        }
    }
}

/**
 * @see org.gradle.api.logging.Logger.trace
 */
fun Task.logTrace(message: String, throwable: Throwable?) {
    if (logger.isTraceEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.trace(message, throwable)
        } else {
            logger.trace("$path: $message", throwable)
        }
    }
}

/**
 * @see org.gradle.api.logging.Logger.trace
 */
fun Task.logTrace(throwable: Throwable) {
    if (logger.isTraceEnabled) {
        if (IS_GRADLE_4_7_OR_ABOVE) {
            logger.trace(throwable.toString(), throwable)
        } else {
            logger.trace("$path: $throwable", throwable)
        }
    }
}
