package name.remal.gradle_plugins.dsl.extensions
import org.gradle.api.logging.Logger

fun Logger.lifecycle(messageBuilder: () -> String?) {
    if (isLifecycleEnabled) {
        val message = messageBuilder() ?: return
        lifecycle(message)
    }
}

fun Logger.quiet(messageBuilder: () -> String?) {
    if (isQuietEnabled) {
        val message = messageBuilder() ?: return
        quiet(message)
    }
}

fun Logger.info(messageBuilder: () -> String?) {
    if (isInfoEnabled) {
        val message = messageBuilder() ?: return
        info(message)
    }
}

fun Logger.warn(messageBuilder: () -> String?) {
    if (isWarnEnabled) {
        val message = messageBuilder() ?: return
        warn(message)
    }
}

fun Logger.error(messageBuilder: () -> String?) {
    if (isErrorEnabled) {
        val message = messageBuilder() ?: return
        error(message)
    }
}

fun Logger.debug(messageBuilder: () -> String?) {
    if (isDebugEnabled) {
        val message = messageBuilder() ?: return
        debug(message)
    }
}

fun Logger.trace(messageBuilder: () -> String?) {
    if (isTraceEnabled) {
        val message = messageBuilder() ?: return
        trace(message)
    }
}
