package name.remal.gradle_plugins.dsl.extensions
import groovy.lang.Closure


fun ConventionWithSelf<*>.addExtensionMethod(methodName: String, function: () -> Unit) {
    convention.add(methodName, object : Closure<Void?>(self, self) {
        init { maximumNumberOfParameters = 0 }
        override fun call(vararg args: Any?): Void? {
            function()
            return null
        }
    })
}

fun <R> ConventionWithSelf<*>.addExtensionMethod(methodName: String, resultType: Class<R>, function: () -> R) {
    convention.add(methodName, object : Closure<R>(self, self) {
        init { maximumNumberOfParameters = 0 }
        override fun call(vararg args: Any?): R {
            return resultType.cast(function())
        }
    })
}


fun ConventionWithSelf<*>.addExtensionMethod1(methodName: String, function: (Any?) -> Unit) {
    convention.add(methodName, object : Closure<Void?>(self, self) {
        init { maximumNumberOfParameters = 1 }
        override fun call(vararg args: Any?): Void? {
            if (args.size != 1) throw IllegalArgumentException("You must pass 1 parameters to method $methodName")
            function(args[0])
            return null
        }
    })
}

fun <R> ConventionWithSelf<*>.addExtensionMethod1(methodName: String, resultType: Class<R>, function: (Any?) -> R) {
    convention.add(methodName, object : Closure<R>(self, self) {
        init { maximumNumberOfParameters = 1 }
        override fun call(vararg args: Any?): R {
            if (args.size != 1) throw IllegalArgumentException("You must pass 1 parameters to method $methodName")
            return resultType.cast(function(args[0]))
        }
    })
}


fun ConventionWithSelf<*>.addExtensionMethod2(methodName: String, function: (Any?, Any?) -> Unit) {
    convention.add(methodName, object : Closure<Void?>(self, self) {
        init { maximumNumberOfParameters = 2 }
        override fun call(vararg args: Any?): Void? {
            if (args.size != 2) throw IllegalArgumentException("You must pass 2 parameters to method $methodName")
            function(args[0], args[1])
            return null
        }
    })
}

fun <R> ConventionWithSelf<*>.addExtensionMethod2(methodName: String, resultType: Class<R>, function: (Any?, Any?) -> R) {
    convention.add(methodName, object : Closure<R>(self, self) {
        init { maximumNumberOfParameters = 2 }
        override fun call(vararg args: Any?): R {
            if (args.size != 2) throw IllegalArgumentException("You must pass 2 parameters to method $methodName")
            return resultType.cast(function(args[0], args[1]))
        }
    })
}


fun ConventionWithSelf<*>.addExtensionMethod3(methodName: String, function: (Any?, Any?, Any?) -> Unit) {
    convention.add(methodName, object : Closure<Void?>(self, self) {
        init { maximumNumberOfParameters = 3 }
        override fun call(vararg args: Any?): Void? {
            if (args.size != 3) throw IllegalArgumentException("You must pass 3 parameters to method $methodName")
            function(args[0], args[1], args[2])
            return null
        }
    })
}

fun <R> ConventionWithSelf<*>.addExtensionMethod3(methodName: String, resultType: Class<R>, function: (Any?, Any?, Any?) -> R) {
    convention.add(methodName, object : Closure<R>(self, self) {
        init { maximumNumberOfParameters = 3 }
        override fun call(vararg args: Any?): R {
            if (args.size != 3) throw IllegalArgumentException("You must pass 3 parameters to method $methodName")
            return resultType.cast(function(args[0], args[1], args[2]))
        }
    })
}


fun ConventionWithSelf<*>.addExtensionMethod4(methodName: String, function: (Any?, Any?, Any?, Any?) -> Unit) {
    convention.add(methodName, object : Closure<Void?>(self, self) {
        init { maximumNumberOfParameters = 4 }
        override fun call(vararg args: Any?): Void? {
            if (args.size != 4) throw IllegalArgumentException("You must pass 4 parameters to method $methodName")
            function(args[0], args[1], args[2], args[3])
            return null
        }
    })
}

fun <R> ConventionWithSelf<*>.addExtensionMethod4(methodName: String, resultType: Class<R>, function: (Any?, Any?, Any?, Any?) -> R) {
    convention.add(methodName, object : Closure<R>(self, self) {
        init { maximumNumberOfParameters = 4 }
        override fun call(vararg args: Any?): R {
            if (args.size != 4) throw IllegalArgumentException("You must pass 4 parameters to method $methodName")
            return resultType.cast(function(args[0], args[1], args[2], args[3]))
        }
    })
}


fun ConventionWithSelf<*>.addExtensionMethod5(methodName: String, function: (Any?, Any?, Any?, Any?, Any?) -> Unit) {
    convention.add(methodName, object : Closure<Void?>(self, self) {
        init { maximumNumberOfParameters = 5 }
        override fun call(vararg args: Any?): Void? {
            if (args.size != 5) throw IllegalArgumentException("You must pass 5 parameters to method $methodName")
            function(args[0], args[1], args[2], args[3], args[4])
            return null
        }
    })
}

fun <R> ConventionWithSelf<*>.addExtensionMethod5(methodName: String, resultType: Class<R>, function: (Any?, Any?, Any?, Any?, Any?) -> R) {
    convention.add(methodName, object : Closure<R>(self, self) {
        init { maximumNumberOfParameters = 5 }
        override fun call(vararg args: Any?): R {
            if (args.size != 5) throw IllegalArgumentException("You must pass 5 parameters to method $methodName")
            return resultType.cast(function(args[0], args[1], args[2], args[3], args[4]))
        }
    })
}


fun ConventionWithSelf<*>.addExtensionMethod6(methodName: String, function: (Any?, Any?, Any?, Any?, Any?, Any?) -> Unit) {
    convention.add(methodName, object : Closure<Void?>(self, self) {
        init { maximumNumberOfParameters = 6 }
        override fun call(vararg args: Any?): Void? {
            if (args.size != 6) throw IllegalArgumentException("You must pass 6 parameters to method $methodName")
            function(args[0], args[1], args[2], args[3], args[4], args[5])
            return null
        }
    })
}

fun <R> ConventionWithSelf<*>.addExtensionMethod6(methodName: String, resultType: Class<R>, function: (Any?, Any?, Any?, Any?, Any?, Any?) -> R) {
    convention.add(methodName, object : Closure<R>(self, self) {
        init { maximumNumberOfParameters = 6 }
        override fun call(vararg args: Any?): R {
            if (args.size != 6) throw IllegalArgumentException("You must pass 6 parameters to method $methodName")
            return resultType.cast(function(args[0], args[1], args[2], args[3], args[4], args[5]))
        }
    })
}


fun ConventionWithSelf<*>.addExtensionMethod7(methodName: String, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> Unit) {
    convention.add(methodName, object : Closure<Void?>(self, self) {
        init { maximumNumberOfParameters = 7 }
        override fun call(vararg args: Any?): Void? {
            if (args.size != 7) throw IllegalArgumentException("You must pass 7 parameters to method $methodName")
            function(args[0], args[1], args[2], args[3], args[4], args[5], args[6])
            return null
        }
    })
}

fun <R> ConventionWithSelf<*>.addExtensionMethod7(methodName: String, resultType: Class<R>, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> R) {
    convention.add(methodName, object : Closure<R>(self, self) {
        init { maximumNumberOfParameters = 7 }
        override fun call(vararg args: Any?): R {
            if (args.size != 7) throw IllegalArgumentException("You must pass 7 parameters to method $methodName")
            return resultType.cast(function(args[0], args[1], args[2], args[3], args[4], args[5], args[6]))
        }
    })
}


fun ConventionWithSelf<*>.addExtensionMethod8(methodName: String, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> Unit) {
    convention.add(methodName, object : Closure<Void?>(self, self) {
        init { maximumNumberOfParameters = 8 }
        override fun call(vararg args: Any?): Void? {
            if (args.size != 8) throw IllegalArgumentException("You must pass 8 parameters to method $methodName")
            function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7])
            return null
        }
    })
}

fun <R> ConventionWithSelf<*>.addExtensionMethod8(methodName: String, resultType: Class<R>, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> R) {
    convention.add(methodName, object : Closure<R>(self, self) {
        init { maximumNumberOfParameters = 8 }
        override fun call(vararg args: Any?): R {
            if (args.size != 8) throw IllegalArgumentException("You must pass 8 parameters to method $methodName")
            return resultType.cast(function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]))
        }
    })
}


fun ConventionWithSelf<*>.addExtensionMethod9(methodName: String, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> Unit) {
    convention.add(methodName, object : Closure<Void?>(self, self) {
        init { maximumNumberOfParameters = 9 }
        override fun call(vararg args: Any?): Void? {
            if (args.size != 9) throw IllegalArgumentException("You must pass 9 parameters to method $methodName")
            function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8])
            return null
        }
    })
}

fun <R> ConventionWithSelf<*>.addExtensionMethod9(methodName: String, resultType: Class<R>, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> R) {
    convention.add(methodName, object : Closure<R>(self, self) {
        init { maximumNumberOfParameters = 9 }
        override fun call(vararg args: Any?): R {
            if (args.size != 9) throw IllegalArgumentException("You must pass 9 parameters to method $methodName")
            return resultType.cast(function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8]))
        }
    })
}


fun ConventionWithSelf<*>.addExtensionMethod10(methodName: String, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> Unit) {
    convention.add(methodName, object : Closure<Void?>(self, self) {
        init { maximumNumberOfParameters = 10 }
        override fun call(vararg args: Any?): Void? {
            if (args.size != 10) throw IllegalArgumentException("You must pass 10 parameters to method $methodName")
            function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9])
            return null
        }
    })
}

fun <R> ConventionWithSelf<*>.addExtensionMethod10(methodName: String, resultType: Class<R>, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> R) {
    convention.add(methodName, object : Closure<R>(self, self) {
        init { maximumNumberOfParameters = 10 }
        override fun call(vararg args: Any?): R {
            if (args.size != 10) throw IllegalArgumentException("You must pass 10 parameters to method $methodName")
            return resultType.cast(function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9]))
        }
    })
}


fun ConventionWithSelf<*>.addExtensionMethod11(methodName: String, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> Unit) {
    convention.add(methodName, object : Closure<Void?>(self, self) {
        init { maximumNumberOfParameters = 11 }
        override fun call(vararg args: Any?): Void? {
            if (args.size != 11) throw IllegalArgumentException("You must pass 11 parameters to method $methodName")
            function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10])
            return null
        }
    })
}

fun <R> ConventionWithSelf<*>.addExtensionMethod11(methodName: String, resultType: Class<R>, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> R) {
    convention.add(methodName, object : Closure<R>(self, self) {
        init { maximumNumberOfParameters = 11 }
        override fun call(vararg args: Any?): R {
            if (args.size != 11) throw IllegalArgumentException("You must pass 11 parameters to method $methodName")
            return resultType.cast(function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10]))
        }
    })
}


fun ConventionWithSelf<*>.addExtensionMethod12(methodName: String, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> Unit) {
    convention.add(methodName, object : Closure<Void?>(self, self) {
        init { maximumNumberOfParameters = 12 }
        override fun call(vararg args: Any?): Void? {
            if (args.size != 12) throw IllegalArgumentException("You must pass 12 parameters to method $methodName")
            function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11])
            return null
        }
    })
}

fun <R> ConventionWithSelf<*>.addExtensionMethod12(methodName: String, resultType: Class<R>, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> R) {
    convention.add(methodName, object : Closure<R>(self, self) {
        init { maximumNumberOfParameters = 12 }
        override fun call(vararg args: Any?): R {
            if (args.size != 12) throw IllegalArgumentException("You must pass 12 parameters to method $methodName")
            return resultType.cast(function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11]))
        }
    })
}


fun ConventionWithSelf<*>.addExtensionMethod13(methodName: String, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> Unit) {
    convention.add(methodName, object : Closure<Void?>(self, self) {
        init { maximumNumberOfParameters = 13 }
        override fun call(vararg args: Any?): Void? {
            if (args.size != 13) throw IllegalArgumentException("You must pass 13 parameters to method $methodName")
            function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12])
            return null
        }
    })
}

fun <R> ConventionWithSelf<*>.addExtensionMethod13(methodName: String, resultType: Class<R>, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> R) {
    convention.add(methodName, object : Closure<R>(self, self) {
        init { maximumNumberOfParameters = 13 }
        override fun call(vararg args: Any?): R {
            if (args.size != 13) throw IllegalArgumentException("You must pass 13 parameters to method $methodName")
            return resultType.cast(function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12]))
        }
    })
}


fun ConventionWithSelf<*>.addExtensionMethod14(methodName: String, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> Unit) {
    convention.add(methodName, object : Closure<Void?>(self, self) {
        init { maximumNumberOfParameters = 14 }
        override fun call(vararg args: Any?): Void? {
            if (args.size != 14) throw IllegalArgumentException("You must pass 14 parameters to method $methodName")
            function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13])
            return null
        }
    })
}

fun <R> ConventionWithSelf<*>.addExtensionMethod14(methodName: String, resultType: Class<R>, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> R) {
    convention.add(methodName, object : Closure<R>(self, self) {
        init { maximumNumberOfParameters = 14 }
        override fun call(vararg args: Any?): R {
            if (args.size != 14) throw IllegalArgumentException("You must pass 14 parameters to method $methodName")
            return resultType.cast(function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13]))
        }
    })
}


fun ConventionWithSelf<*>.addExtensionMethod15(methodName: String, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> Unit) {
    convention.add(methodName, object : Closure<Void?>(self, self) {
        init { maximumNumberOfParameters = 15 }
        override fun call(vararg args: Any?): Void? {
            if (args.size != 15) throw IllegalArgumentException("You must pass 15 parameters to method $methodName")
            function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13], args[14])
            return null
        }
    })
}

fun <R> ConventionWithSelf<*>.addExtensionMethod15(methodName: String, resultType: Class<R>, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> R) {
    convention.add(methodName, object : Closure<R>(self, self) {
        init { maximumNumberOfParameters = 15 }
        override fun call(vararg args: Any?): R {
            if (args.size != 15) throw IllegalArgumentException("You must pass 15 parameters to method $methodName")
            return resultType.cast(function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13], args[14]))
        }
    })
}


fun ConventionWithSelf<*>.addExtensionMethod16(methodName: String, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> Unit) {
    convention.add(methodName, object : Closure<Void?>(self, self) {
        init { maximumNumberOfParameters = 16 }
        override fun call(vararg args: Any?): Void? {
            if (args.size != 16) throw IllegalArgumentException("You must pass 16 parameters to method $methodName")
            function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13], args[14], args[15])
            return null
        }
    })
}

fun <R> ConventionWithSelf<*>.addExtensionMethod16(methodName: String, resultType: Class<R>, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> R) {
    convention.add(methodName, object : Closure<R>(self, self) {
        init { maximumNumberOfParameters = 16 }
        override fun call(vararg args: Any?): R {
            if (args.size != 16) throw IllegalArgumentException("You must pass 16 parameters to method $methodName")
            return resultType.cast(function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13], args[14], args[15]))
        }
    })
}


fun ConventionWithSelf<*>.addExtensionMethod17(methodName: String, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> Unit) {
    convention.add(methodName, object : Closure<Void?>(self, self) {
        init { maximumNumberOfParameters = 17 }
        override fun call(vararg args: Any?): Void? {
            if (args.size != 17) throw IllegalArgumentException("You must pass 17 parameters to method $methodName")
            function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13], args[14], args[15], args[16])
            return null
        }
    })
}

fun <R> ConventionWithSelf<*>.addExtensionMethod17(methodName: String, resultType: Class<R>, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> R) {
    convention.add(methodName, object : Closure<R>(self, self) {
        init { maximumNumberOfParameters = 17 }
        override fun call(vararg args: Any?): R {
            if (args.size != 17) throw IllegalArgumentException("You must pass 17 parameters to method $methodName")
            return resultType.cast(function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13], args[14], args[15], args[16]))
        }
    })
}


fun ConventionWithSelf<*>.addExtensionMethod18(methodName: String, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> Unit) {
    convention.add(methodName, object : Closure<Void?>(self, self) {
        init { maximumNumberOfParameters = 18 }
        override fun call(vararg args: Any?): Void? {
            if (args.size != 18) throw IllegalArgumentException("You must pass 18 parameters to method $methodName")
            function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13], args[14], args[15], args[16], args[17])
            return null
        }
    })
}

fun <R> ConventionWithSelf<*>.addExtensionMethod18(methodName: String, resultType: Class<R>, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> R) {
    convention.add(methodName, object : Closure<R>(self, self) {
        init { maximumNumberOfParameters = 18 }
        override fun call(vararg args: Any?): R {
            if (args.size != 18) throw IllegalArgumentException("You must pass 18 parameters to method $methodName")
            return resultType.cast(function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13], args[14], args[15], args[16], args[17]))
        }
    })
}


fun ConventionWithSelf<*>.addExtensionMethod19(methodName: String, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> Unit) {
    convention.add(methodName, object : Closure<Void?>(self, self) {
        init { maximumNumberOfParameters = 19 }
        override fun call(vararg args: Any?): Void? {
            if (args.size != 19) throw IllegalArgumentException("You must pass 19 parameters to method $methodName")
            function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13], args[14], args[15], args[16], args[17], args[18])
            return null
        }
    })
}

fun <R> ConventionWithSelf<*>.addExtensionMethod19(methodName: String, resultType: Class<R>, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> R) {
    convention.add(methodName, object : Closure<R>(self, self) {
        init { maximumNumberOfParameters = 19 }
        override fun call(vararg args: Any?): R {
            if (args.size != 19) throw IllegalArgumentException("You must pass 19 parameters to method $methodName")
            return resultType.cast(function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13], args[14], args[15], args[16], args[17], args[18]))
        }
    })
}


fun ConventionWithSelf<*>.addExtensionMethod20(methodName: String, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> Unit) {
    convention.add(methodName, object : Closure<Void?>(self, self) {
        init { maximumNumberOfParameters = 20 }
        override fun call(vararg args: Any?): Void? {
            if (args.size != 20) throw IllegalArgumentException("You must pass 20 parameters to method $methodName")
            function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13], args[14], args[15], args[16], args[17], args[18], args[19])
            return null
        }
    })
}

fun <R> ConventionWithSelf<*>.addExtensionMethod20(methodName: String, resultType: Class<R>, function: (Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?, Any?) -> R) {
    convention.add(methodName, object : Closure<R>(self, self) {
        init { maximumNumberOfParameters = 20 }
        override fun call(vararg args: Any?): R {
            if (args.size != 20) throw IllegalArgumentException("You must pass 20 parameters to method $methodName")
            return resultType.cast(function(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13], args[14], args[15], args[16], args[17], args[18], args[19]))
        }
    })
}
