package name.remal.gradle_plugins.dsl.extensions

import name.remal.findCompatibleMethod
import name.remal.uncheckedCast
import org.gradle.api.provider.Property
import org.gradle.api.tasks.bundling.AbstractArchiveTask

var AbstractArchiveTask.extensionCompatible: String?
    get() {
        this.javaClass.findCompatibleMethod(Property::class.java, "getArchiveExtension")?.let { method ->
            method.isAccessible = true
            val property = method.invoke(this).uncheckedCast<Property<Any>>()
            return property.orNull?.toString()
        }

        this.javaClass.findCompatibleMethod(String::class.java, "getExtension")?.let { method ->
            method.isAccessible = true
            return method.invoke(this).uncheckedCast<String>()
        }

        throw IllegalStateException("Getter can't be found")
    }
    set(value) {
        this.javaClass.findCompatibleMethod(Property::class.java, "getArchiveExtension")?.let { method ->
            method.isAccessible = true
            val property = method.invoke(this).uncheckedCast<Property<Any>>()
            property.set(value)
            return
        }

        this.javaClass.findCompatibleMethod("setExtension", String::class.java)?.let { method ->
            method.isAccessible = true
            method.invoke(this, value)
            return
        }

        throw IllegalStateException("Setter can't be found")
    }


var AbstractArchiveTask.classifierCompatible: String?
    get() {
        this.javaClass.findCompatibleMethod(Property::class.java, "getArchiveClassifier")?.let { method ->
            method.isAccessible = true
            val property = method.invoke(this).uncheckedCast<Property<Any>>()
            return property.orNull?.toString()
        }

        this.javaClass.findCompatibleMethod(String::class.java, "getClassifier")?.let { method ->
            method.isAccessible = true
            return method.invoke(this).uncheckedCast<String>()
        }

        throw IllegalStateException("Getter can't be found")
    }
    set(value) {
        this.javaClass.findCompatibleMethod(Property::class.java, "getArchiveClassifier")?.let { method ->
            method.isAccessible = true
            val property = method.invoke(this).uncheckedCast<Property<Any>>()
            property.set(value)
            return
        }

        this.javaClass.findCompatibleMethod("setClassifier", String::class.java)?.let { method ->
            method.isAccessible = true
            method.invoke(this, value)
            return
        }

        throw IllegalStateException("Setter can't be found")
    }
