package name.remal.gradle_plugins.dsl.extensions

import name.remal.version.Version
import org.gradle.internal.jvm.JavaInfo
import java.nio.charset.StandardCharsets.UTF_8

fun JavaInfo.retrieveVersion(): Version? {
    val command = arrayOf(javaExecutable.absolutePath, "-version")
    val process = ProcessBuilder().command(*command).start()
    val exitValue = process.waitFor()
    if (exitValue != 0) {
        throw IllegalStateException("\"${command.joinToString("\", \"")}\" returned $exitValue")
    }

    process.inputStream?.use { it.readBytes() }?.let(::parseJavaVersionOutput)?.let { return it }
    process.errorStream?.use { it.readBytes() }?.let(::parseJavaVersionOutput)?.let { return it }

    return null
}

private fun parseJavaVersionOutput(bytes: ByteArray): Version? {
    val text = bytes.toString(UTF_8).replace("\r", "").trim()
    val lines = text.split('\n')
    for (line in lines) {
        val versionStr = line.toLowerCase().substringAfter("version", "").trim('\t', ' ', '"', '\'')
        if (versionStr.isNotEmpty()) {
            return Version.parse(versionStr)
        }
    }
    return null
}
