package name.remal.gradle_plugins.dsl.utils

import name.remal.uncheckedCast
import org.objectweb.asm.ClassVisitor
import org.objectweb.asm.commons.ClassRemapper
import org.objectweb.asm.commons.Remapper

class DependenciesCollectorClassVisitor(delegate: ClassVisitor?) : ClassRemapper(delegate, DependenciesCollectorRemapper()) {

    val dependencyInternalClassNames: Set<String>
        get() = remapper.uncheckedCast<DependenciesCollectorRemapper>()
            .dependencyInternalClassNames
            .toSortedSet()
            .apply { internalClassName?.let(this::remove) }

    private var internalClassName: String? = null
    override fun visit(version: Int, access: Int, name: String, signature: String?, superName: String?, interfaces: Array<String>?) {
        internalClassName = name
        super.visit(version, access, name, signature, superName, interfaces)
    }

    private class DependenciesCollectorRemapper : Remapper() {
        val dependencyInternalClassNames: MutableSet<String> = hashSetOf()
        override fun map(internalName: String?): String? {
            internalName?.let(dependencyInternalClassNames::add)
            return null
        }
    }

}
