package name.remal.gradle_plugins.dsl.utils

import name.remal.KotlinAllOpen
import name.remal.gradle_plugins.dsl.GradleEnumVersion.GRADLE_VERSION_6_0
import name.remal.gradle_plugins.dsl.extensions.compareTo
import org.gradle.api.file.FileCollection
import org.gradle.api.internal.file.AbstractFileCollection
import org.gradle.util.GradleVersion
import java.io.File

fun newFileCollection(filesFactory: () -> Iterable<File>): FileCollection {
    val filesSet = lazy { filesFactory().toSet() }
    if (GradleVersion.current() >= GRADLE_VERSION_6_0) {
        return FileCollectionImpl_6(filesSet)
    } else {
        return FileCollectionImpl_5(filesSet)
    }
}

fun newFileCollection(files: Iterable<File>) = newFileCollection({ files })
fun newFileCollection(vararg files: File) = newFileCollection(files.toList())


@KotlinAllOpen
private class FileCollectionImpl_6(private val filesSet: Lazy<Set<File>>) : AbstractFileCollection() {
    override fun getFiles(): Set<File> = filesSet.value
    override fun getDisplayName() = "file collection"
    override fun equals(other: Any?) = other is FileCollection && other.files == files
    override fun hashCode() = 1 + files.hashCode()
}

@KotlinAllOpen
private class FileCollectionImpl_5(private val filesSet: Lazy<Set<File>>) : AbstractFileCollection() {
    override fun getFiles(): Set<File> = filesSet.value
    override fun getBuildDependencies() = EmptyTaskDependencies
    override fun getDisplayName() = "file collection"
    override fun equals(other: Any?) = other is FileCollection && other.files == files
    override fun hashCode() = 1 + files.hashCode()
}
