package name.remal.gradle_plugins.dsl.utils

import org.jdom2.output.Format
import org.jdom2.output.Format.getCompactFormat
import org.jdom2.output.Format.getPrettyFormat
import org.jdom2.output.Format.getRawFormat
import org.jdom2.output.LineSeparator.UNIX
import org.jdom2.output.XMLOutputter

private fun Format.defaultSettings() = this
    .setEncoding("UTF-8")
    .setOmitDeclaration(false)
    .setOmitEncoding(false)
    .setLineSeparator(UNIX)

val XML_PRETTY_OUTPUTTER = XMLOutputter(getPrettyFormat().defaultSettings())
val XML_COMPACT_OUTPUTTER = XMLOutputter(getCompactFormat().defaultSettings())
val XML_OUTPUTTER = XMLOutputter(getRawFormat().defaultSettings())
