/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala_maven.VersionNumber;

class VersionNumberMask
extends VersionNumber {
    private static final Pattern _regexp = Pattern.compile("(\\d+)(\\.\\d+)?(\\.\\d+)?([-\\.].+)?");

    public VersionNumberMask(String s) {
        Matcher match = _regexp.matcher(s);
        if (!match.find()) {
            throw new IllegalArgumentException("invalid versionNumber : major.minor(.bugfix)(modifier) :" + s);
        }
        this.major = Integer.parseInt(match.group(1));
        this.minor = -1;
        if (match.group(2) != null && match.group(2).length() > 1) {
            this.minor = Integer.parseInt(match.group(2).substring(1));
        }
        this.bugfix = -1;
        if (match.group(3) != null && match.group(3).length() > 1) {
            this.bugfix = Integer.parseInt(match.group(3).substring(1));
        }
        this.modifier = null;
        if (match.group(4) != null && match.group(4).length() > 1) {
            this.modifier = match.group(4);
        }
    }

    @Override
    public int compareTo(VersionNumber o) {
        int back = 0;
        if (back == 0 && this.major > o.major) {
            back = 1;
        }
        if (back == 0 && this.major < o.major) {
            back = -1;
        }
        if (back == 0 && this.minor > -1 && this.minor > o.minor) {
            back = 1;
        }
        if (back == 0 && this.minor > -1 && this.minor < o.minor) {
            back = -1;
        }
        if (back == 0 && this.bugfix > -1 && this.bugfix > o.bugfix) {
            back = 1;
        }
        if (back == 0 && this.bugfix > -1 && this.bugfix < o.bugfix) {
            back = -1;
        }
        return back;
    }
}

