/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.bull.javamelody.internal.web.MonitoringController;

public class CustomResourceFilter
implements Filter {
    private final Map<String, String> customResources = new HashMap<String, String>();

    public void init(FilterConfig filterConfig) throws ServletException {
        ArrayList<String> parameterNames = Collections.list(filterConfig.getInitParameterNames());
        for (String parameterName : parameterNames) {
            this.customResources.put(parameterName, filterConfig.getInitParameter(parameterName));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String resource = request.getParameter("resource");
        if (resource != null && this.customResources.get(resource) != null) {
            String customResource = this.customResources.get(resource);
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            MonitoringController.addHeadersForResource(httpResponse, customResource);
            if (this.customResources.get("useForward") == null) {
                request.getRequestDispatcher(customResource).include(request, response);
            } else {
                request.getRequestDispatcher(customResource).forward(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

