/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Logger;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.common.Parameters;

public class JdbcDriver
implements Driver {
    static final JdbcDriver SINGLETON = new JdbcDriver();

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        int index;
        if ("false".equals(info.get("javamelody"))) {
            return null;
        }
        String myUrl = url;
        String proxiedDriver = info.getProperty("driver");
        if (proxiedDriver == null && myUrl != null && (index = myUrl.indexOf("driver=")) != -1) {
            proxiedDriver = myUrl.substring(index + "driver=".length());
            myUrl = myUrl.substring(0, index - 1);
        }
        if (proxiedDriver == null) {
            return null;
        }
        try {
            Class.forName(proxiedDriver, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(e.getMessage(), e);
        }
        Properties myInfo = (Properties)info.clone();
        myInfo.remove("driver");
        myInfo.put("javamelody", "false");
        Parameters.initJdbcDriverParameters(myUrl, myInfo);
        return JdbcWrapper.SINGLETON.createConnectionProxy(DriverManager.getConnection(myUrl, myInfo));
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().endsWith("dbcp.BasicDataSource")) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getMajorVersion() {
        return -1;
    }

    @Override
    public int getMinorVersion() {
        return -1;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[lastConnectUrl=" + Parameters.getLastConnectUrl() + ", lastConnectInfo=" + String.valueOf(Parameters.getLastConnectInfo()) + "]";
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger("global");
    }

    static {
        try {
            DriverManager.registerDriver(SINGLETON);
            LOG.debug("JDBC driver registered");
            for (Driver driver : Collections.list(DriverManager.getDrivers())) {
                if (driver == SINGLETON) continue;
                DriverManager.deregisterDriver(driver);
                DriverManager.registerDriver(driver);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

