/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Set;
import javax.sql.DataSource;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.common.Parameters;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;
import org.springframework.jndi.JndiObjectFactoryBean;

public class SpringDataSourceBeanPostProcessor
implements BeanPostProcessor,
PriorityOrdered {
    private Set<String> excludedDatasources;
    private int order = Integer.MAX_VALUE;
    private final Class<?> delegatingDataSourceClass = SpringDataSourceBeanPostProcessor.getDelegatingDataSourceClass();

    public void setExcludedDatasources(Set<String> excludedDatasources) {
        this.excludedDatasources = excludedDatasources;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    private boolean isExcludedDataSource(String beanName) {
        if (this.excludedDatasources != null && this.excludedDatasources.contains(beanName)) {
            LOG.debug("Spring datasource excluded: " + beanName);
            return true;
        }
        return false;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof DataSource) {
            if (this.isExcludedDataSource(beanName) || Parameters.isNoDatabase() || this.isDelegatingDataSourceAndAlreadyProxied(bean, beanName)) {
                return bean;
            }
            DataSource dataSource = (DataSource)bean;
            JdbcWrapper.registerSpringDataSource(beanName, dataSource);
            DataSource result = JdbcWrapper.SINGLETON.createDataSourceProxy(beanName, dataSource);
            LOG.debug("Spring datasource wrapped: " + beanName);
            return result;
        }
        if (bean instanceof JndiObjectFactoryBean) {
            if (this.isExcludedDataSource(beanName) || Parameters.isNoDatabase()) {
                return bean;
            }
            Object result = this.createProxy(bean, beanName);
            LOG.debug("Spring JNDI factory wrapped: " + beanName);
            return result;
        }
        return bean;
    }

    private Object createProxy(final Object bean, final String beanName) {
        InvocationHandler invocationHandler = new InvocationHandler(){
            final /* synthetic */ SpringDataSourceBeanPostProcessor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = method.invoke(bean, args);
                if (result instanceof DataSource) {
                    result = JdbcWrapper.SINGLETON.createDataSourceProxy(beanName, (DataSource)result);
                }
                return result;
            }
        };
        return JdbcWrapper.createProxy(bean, invocationHandler);
    }

    private boolean isDelegatingDataSourceAndAlreadyProxied(Object bean, String beanName) {
        if (this.delegatingDataSourceClass != null && this.delegatingDataSourceClass.isInstance(bean)) {
            DataSource targetDataSource;
            try {
                targetDataSource = (DataSource)this.delegatingDataSourceClass.getMethod("getTargetDataSource", new Class[0]).invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            if (JdbcWrapper.isProxyAlready(targetDataSource)) {
                LOG.debug("Spring delegating datasource excluded: " + beanName);
                return true;
            }
        }
        return false;
    }

    private static Class<?> getDelegatingDataSourceClass() {
        try {
            return Class.forName("org.springframework.jdbc.datasource.DelegatingDataSource");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

