/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.Action;
import net.bull.javamelody.internal.model.Collector;
import net.bull.javamelody.internal.model.ConnectionInformations;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.CounterRequestContext;
import net.bull.javamelody.internal.model.DatabaseInformations;
import net.bull.javamelody.internal.model.HeapHistogram;
import net.bull.javamelody.internal.model.JavaInformations;
import net.bull.javamelody.internal.model.JndiBinding;
import net.bull.javamelody.internal.model.MBeanNode;
import net.bull.javamelody.internal.model.MavenArtifact;
import net.bull.javamelody.internal.model.ProcessInformations;
import net.bull.javamelody.internal.model.RemoteCall;
import net.bull.javamelody.internal.model.SamplingProfiler;
import net.bull.javamelody.internal.model.SessionInformations;
import net.bull.javamelody.internal.model.ThreadInformations;

public class RemoteCollector {
    private final String application;
    private List<URL> urls;
    private Collector collector;
    private List<JavaInformations> javaInformationsList;
    private Map<JavaInformations, List<CounterRequestContext>> currentRequests;
    private final List<Counter> newCounters = new ArrayList<Counter>();
    private List<RemoteCollector> remoteCollectors;
    private boolean aggregatedApplication;
    private final boolean aggregationApplication;
    private String cookies;
    private boolean aggregationDisabled;

    public RemoteCollector(String application, List<URL> urls) throws IOException {
        assert (application != null);
        assert (urls != null);
        this.application = application;
        this.urls = urls;
        this.aggregatedApplication = this.isAggregatedApplication();
        this.aggregationApplication = this.isAggregationApplication();
    }

    void refreshAggregated() throws IOException {
        this.aggregatedApplication = this.isAggregatedApplication();
    }

    String collectData() throws IOException {
        return this.collectDataWithUrls(this.getURLs());
    }

    public String collectDataIncludingCurrentRequests() throws IOException {
        ArrayList<URL> urlsWithCurrentRequests = new ArrayList<URL>();
        for (URL url : this.getURLs()) {
            urlsWithCurrentRequests.add(new URL(String.valueOf(url) + "&part=defaultWithCurrentRequests"));
        }
        return this.collectDataWithUrls(urlsWithCurrentRequests);
    }

    private String collectDataWithUrls(List<URL> urlsForCollect) throws IOException {
        ArrayList<JavaInformations> javaInfosList = new ArrayList<JavaInformations>();
        HashMap<JavaInformations, List<CounterRequestContext>> counterRequestContextsByJavaInformations = new HashMap<JavaInformations, List<CounterRequestContext>>();
        StringBuilder sb = new StringBuilder();
        IOException exception = null;
        if (!this.aggregationApplication) {
            for (URL url : urlsForCollect) {
                try {
                    ArrayList<Counter> counters = new ArrayList<Counter>();
                    List<Serializable> serialized = this.createRemoteCall(url).collectData();
                    this.dispatchSerializables(serialized, counters, javaInfosList, counterRequestContextsByJavaInformations, sb);
                    this.addRequestsAndErrors(counters);
                    if (!this.aggregatedApplication) continue;
                    this.newCounters.addAll(counters);
                }
                catch (IOException e) {
                    exception = e;
                }
            }
        } else {
            assert (this.remoteCollectors != null);
            for (RemoteCollector remoteCollector : this.remoteCollectors) {
                javaInfosList.addAll(remoteCollector.getJavaInformationsList());
                counterRequestContextsByJavaInformations.putAll(remoteCollector.getCurrentRequests());
                List<Counter> counters = remoteCollector.getNewCounters();
                if (counters.isEmpty()) {
                    counters.addAll(remoteCollector.getCollector().getCounters());
                    remoteCollector.aggregatedApplication = true;
                }
                this.addRequestsAndErrors(counters);
                if (!this.aggregatedApplication) continue;
                this.newCounters.addAll(counters);
            }
        }
        if (exception != null && javaInfosList.isEmpty()) {
            throw exception;
        }
        this.javaInformationsList = javaInfosList;
        this.currentRequests = counterRequestContextsByJavaInformations;
        String messageForReport = sb.length() == 0 ? null : sb.toString();
        return messageForReport;
    }

    private void dispatchSerializables(List<Serializable> serialized, List<Counter> counters, List<JavaInformations> javaInfosList, Map<JavaInformations, List<CounterRequestContext>> counterRequestContextsByJavaInformations, StringBuilder sb) {
        JavaInformations latestJavaInformations = null;
        ArrayList<CounterRequestContext> counterRequestContextsList = new ArrayList<CounterRequestContext>();
        for (Serializable serializable : serialized) {
            if (serializable instanceof Counter) {
                Counter counter = (Counter)serializable;
                counter.setApplication(this.application);
                counters.add(counter);
                continue;
            }
            if (serializable instanceof JavaInformations) {
                JavaInformations newJavaInformations;
                latestJavaInformations = newJavaInformations = (JavaInformations)serializable;
                javaInfosList.add(newJavaInformations);
                continue;
            }
            if (serializable instanceof String) {
                sb.append(serializable).append('\n');
                continue;
            }
            if (!(serializable instanceof CounterRequestContext)) continue;
            CounterRequestContext counterRequestContext = (CounterRequestContext)serializable;
            counterRequestContextsList.add(counterRequestContext);
        }
        if (!counterRequestContextsList.isEmpty()) {
            counterRequestContextsByJavaInformations.put(latestJavaInformations, counterRequestContextsList);
        }
    }

    private boolean isAggregatedApplication() throws IOException {
        for (List<String> applications : Parameters.getApplicationsByAggregationApplication().values()) {
            if (!applications.contains(this.application)) continue;
            return true;
        }
        return false;
    }

    final boolean isAggregationApplication() throws IOException {
        return Parameters.getApplicationsByAggregationApplication().containsKey(this.application);
    }

    public String executeActionAndCollectData(Action action, String counterName, String sessionId, String threadId, String jobId, String cacheId) throws IOException {
        assert (action != null);
        ArrayList<URL> actionUrls = new ArrayList<URL>(this.getURLs().size());
        for (URL url : this.getURLs()) {
            URL actionUrl = this.createRemoteCall(url).getActionUrl(action, counterName, sessionId, threadId, jobId, cacheId);
            actionUrls.add(actionUrl);
        }
        return this.collectDataWithUrls(actionUrls);
    }

    public List<SessionInformations> collectSessionInformations(String sessionId) throws IOException {
        if (sessionId == null) {
            ArrayList<SessionInformations> sessionsInformations = new ArrayList<SessionInformations>();
            for (URL url : this.getURLs()) {
                List<SessionInformations> sessions = this.createRemoteCall(url).collectSessionInformations(null);
                sessionsInformations.addAll(sessions);
            }
            SessionListener.sortSessions(sessionsInformations);
            return sessionsInformations;
        }
        for (URL url : this.getURLs()) {
            List<SessionInformations> sessions = this.createRemoteCall(url).collectSessionInformations(sessionId);
            if (sessions.isEmpty()) continue;
            return sessions;
        }
        return Collections.emptyList();
    }

    public List<SamplingProfiler.SampledMethod> collectHotspots() throws IOException {
        HashMap<SamplingProfiler.SampledMethod, SamplingProfiler.SampledMethod> map = new HashMap<SamplingProfiler.SampledMethod, SamplingProfiler.SampledMethod>();
        for (URL url : this.getURLs()) {
            List<SamplingProfiler.SampledMethod> hotspots = this.createRemoteCall(url).collectHotspots();
            if (this.getURLs().size() == 1) {
                return hotspots;
            }
            for (SamplingProfiler.SampledMethod method : hotspots) {
                SamplingProfiler.SampledMethod previous = (SamplingProfiler.SampledMethod)map.get(method);
                if (previous == null) {
                    map.put(method, method);
                    continue;
                }
                previous.setCount(previous.getCount() + method.getCount());
            }
        }
        ArrayList<SamplingProfiler.SampledMethod> hotspots = new ArrayList<SamplingProfiler.SampledMethod>(map.values());
        hotspots.sort(Comparator.naturalOrder());
        return hotspots;
    }

    public HeapHistogram collectHeapHistogram() throws IOException {
        HeapHistogram heapHistoTotal = null;
        for (URL url : this.getURLs()) {
            HeapHistogram heapHisto = this.createRemoteCall(url).collectHeapHistogram();
            if (heapHistoTotal == null) {
                heapHistoTotal = heapHisto;
                continue;
            }
            heapHistoTotal.add(heapHisto);
        }
        return heapHistoTotal;
    }

    public DatabaseInformations collectDatabaseInformations(int requestIndex) throws IOException {
        URL url = this.getURLs().get(0);
        return this.createRemoteCall(url).collectDatabaseInformations(requestIndex);
    }

    public List<List<ConnectionInformations>> collectConnectionInformations() throws IOException {
        ArrayList<List<ConnectionInformations>> connectionInformations = new ArrayList<List<ConnectionInformations>>();
        for (URL url : this.getURLs()) {
            List<List<ConnectionInformations>> connections = this.createRemoteCall(url).collectConnectionInformations();
            connectionInformations.addAll(connections);
        }
        return connectionInformations;
    }

    public Map<String, List<ProcessInformations>> collectProcessInformations() throws IOException {
        LinkedHashMap<String, List<ProcessInformations>> result = new LinkedHashMap<String, List<ProcessInformations>>();
        for (URL url : this.getURLs()) {
            Map<String, List<ProcessInformations>> processesByTitle = this.createRemoteCall(url).collectProcessInformations();
            result.putAll(processesByTitle);
        }
        return result;
    }

    public List<JndiBinding> collectJndiBindings(String path) throws IOException {
        URL url = this.getURLs().get(0);
        return this.createRemoteCall(url).collectJndiBindings(path);
    }

    public Map<String, List<MBeanNode>> collectMBeans() throws IOException {
        LinkedHashMap<String, List<MBeanNode>> result = new LinkedHashMap<String, List<MBeanNode>>();
        for (URL url : this.getURLs()) {
            Map<String, List<MBeanNode>> mbeansByTitle = this.createRemoteCall(url).collectMBeans();
            result.putAll(mbeansByTitle);
        }
        return result;
    }

    public Map<String, MavenArtifact> collectWebappDependencies() throws IOException {
        URL url = this.getURLs().get(0);
        return this.createRemoteCall(url).collectWebappDependencies();
    }

    public Map<String, Date> collectWebappVersions() throws IOException {
        URL url = this.getURLs().get(0);
        return this.createRemoteCall(url).collectWebappVersions();
    }

    public Map<JavaInformations, List<CounterRequestContext>> collectCurrentRequests() throws IOException {
        LinkedHashMap<JavaInformations, List<CounterRequestContext>> result = new LinkedHashMap<JavaInformations, List<CounterRequestContext>>();
        for (URL url : this.getURLs()) {
            Map<JavaInformations, List<CounterRequestContext>> requests = this.createRemoteCall(url).collectCurrentRequests();
            result.putAll(requests);
        }
        return result;
    }

    List<List<ThreadInformations>> getThreadInformationsLists() {
        ArrayList<List<ThreadInformations>> result = new ArrayList<List<ThreadInformations>>();
        for (JavaInformations javaInformations : this.javaInformationsList) {
            result.add(new ArrayList<ThreadInformations>(javaInformations.getThreadInformationsList()));
        }
        return result;
    }

    public Map<String, byte[]> collectJRobins(int width, int height) throws IOException {
        URL url = this.getURLs().get(0);
        return this.createRemoteCall(url).collectJRobins(width, height);
    }

    public Map<String, byte[]> collectOtherJRobins(int width, int height) throws IOException {
        URL url = this.getURLs().get(0);
        return this.createRemoteCall(url).collectOtherJRobins(width, height);
    }

    public byte[] collectJRobin(String graphName, int width, int height) throws IOException {
        URL url = this.getURLs().get(0);
        return this.createRemoteCall(url).collectJRobin(graphName, width, height);
    }

    public String collectSqlRequestExplainPlan(String sqlRequest) throws IOException {
        URL url = this.getURLs().get(0);
        return this.createRemoteCall(url).collectSqlRequestExplainPlan(sqlRequest);
    }

    private void addRequestsAndErrors(List<Counter> counters) {
        if (this.collector == null || this.aggregationDisabled) {
            ArrayList<Counter> clonedCounters = new ArrayList<Counter>();
            for (Counter counter : counters) {
                clonedCounters.add(counter.clone());
            }
            this.collector = new Collector(this.application, clonedCounters);
        } else {
            for (Counter newCounter : counters) {
                Counter counter = this.collector.getCounterByName(newCounter.getName());
                counter.setDisplayed(newCounter.isDisplayed());
                counter.addRequestsAndErrors(newCounter);
            }
        }
    }

    private RemoteCall createRemoteCall(URL url) {
        RemoteCall remoteCall = new RemoteCall(url);
        remoteCall.setCookies(this.cookies);
        return remoteCall;
    }

    public static String getHostAndPort(URL url) {
        if (url.getPort() != -1) {
            return url.getHost() + ":" + url.getPort();
        }
        return url.getHost();
    }

    public String getApplication() {
        return this.application;
    }

    public List<URL> getURLs() {
        if (this.aggregationApplication) {
            ArrayList<URL> result = new ArrayList<URL>();
            for (RemoteCollector remoteCollector : this.remoteCollectors) {
                result.addAll(remoteCollector.getURLs());
            }
            return result;
        }
        return this.urls;
    }

    public Collector getCollector() {
        return this.collector;
    }

    public List<JavaInformations> getJavaInformationsList() {
        return this.javaInformationsList;
    }

    public Map<JavaInformations, List<CounterRequestContext>> getCurrentRequests() {
        return this.currentRequests;
    }

    List<Counter> getNewCounters() {
        return this.newCounters;
    }

    void clearNewCounters() {
        this.newCounters.clear();
    }

    void setRemoteCollectors(List<RemoteCollector> remoteCollectors) {
        this.remoteCollectors = remoteCollectors;
    }

    public void setURLs(List<URL> newURLs) {
        assert (newURLs != null);
        this.urls = newURLs;
    }

    public void setCookies(String cookies) {
        this.cookies = cookies;
    }

    public void disableAggregation() {
        this.aggregationDisabled = true;
    }
}

